package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.FireStation;

import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
* 微型消防站 Mapper 接口
*
* @author system_generator
* @date 2021-06-28
*/
public interface FireStationMapper extends BaseMapper<FireStation> {
	
	
	
	@Select("<script>"
			+ "select * from  cb_fire_station  where cb_fire_station.is_delete=0 "
			+ "<if test='par.name!=null'> and cb_fire_station.name like  CONCAT('%',#{par.name},'%') </if>"	
			+ "<if test='par.bizCompanyId!=null'> and cb_fire_station.biz_company_id = #{par.bizCompanyId} </if>"	
			+"limit  #{pageNum},#{pageSize}"
			+ "</script>")	
	List<FireStationDto>getFireStation(@Param("pageNum")int pageNum,@Param("pageSize")int pageSize,@Param("par")FireStationDto par);
	@Select("<script>"
			+ "select COUNT(cb_fire_station.sequence_nbr) num from  cb_fire_station  where cb_fire_station.is_delete=0 "
			+ "<if test='par.name!=null'> and cb_fire_station.name like  CONCAT('%',#{par.name},'%') </if>"	
			+ "<if test='par.bizCompanyId!=null'> and cb_fire_station.biz_company_id = #{par.bizCompanyId} </if>"	
			+ "</script>")	
	 Map<String, Long> getFireStationCount(@Param("par")FireStationDto par);

}
