package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.FireBrigadeResourceDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.jcs.api.vo.FireTeamListVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.FireTeamVo;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
* 消防队伍 Mapper 接口
*
* @author tb
* @date 2021-06-07
*/
public interface FireTeamMapper extends BaseMapper<FireTeam> {

	@Select("<script>"
	+ "select a.sequence_nbr sequenceNbr, a.img,a.name,a.contact_user contactUser,a.contact_phone contactPhone, a.address from cb_fire_team a  where a.is_delete=0"
	+ "<if test='par.parent!=null'>" + "and a.parent= #{par.parent}" + "</if>"
	+ "<if test='par.typeCode!=null'>" + "and a.type_code= #{par.typeCode}" + "</if>"
	+ "<if test='par.companyCode!=null'>" + "and a.company_code= #{par.companyCode}" + "</if>"
	+ "<if test='par.name!=null'>" + "and a.name= #{par.name}" + "</if>"
	+ "</script>")
	List<FireTeamVo> getFireTeam(int pageNum, int pageSize, FireTeamListVo par);
	@Select("<script>"
	+ "select COUNT(a.sequence_nbr) num from cb_fire_team a  where a.is_delete=0"
	+ "<if test='par.parent!=null'>" + "and a.parent= #{par.parent}" + "</if>"
	+ "<if test='par.typeCode!=null'>" + "and a.type_code= #{par.typeCode}" + "</if>"
	+ "<if test='par.companyCode!=null'>" + "and a.company_code= #{par.companyCode}" + "</if>"
	+ "<if test='par.name!=null'>" + " and a.name= #{par.name}" + "</if>"
	+ "</script>")
	Map<String, Long> getFireTeamCount(int pageNum, int pageSize, FireTeamListVo par);

	/**
	 * 返回监控大队信息列表
	 *
	 * @return
	 */
	List<FireBrigadeResourceDto> listMonitorFireBrigade();
}
