package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jcs.api.entity.Firefighters;
import com.yeejoin.amos.boot.module.jcs.api.vo.FirefightersListVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
* 消防队员 Mapper 接口
*
* @author tb
* @date 2021-06-07
*/
public interface FirefightersMapper extends BaseMapper<Firefighters> {
	
	
/**
 * 
 * 消防人员首页列表
 *
 ***/	
@Select("<script>"
+ "select a.* from  cb_firefighters a LEFT JOIN cb_firefighters_post b  on a.sequence_nbr=b.firefighters_id where a.is_delete=0 "
+ "<if test='par.postQualification!=null'>" + "and b.post_qualification_code = #{par.postQualification}" + "</if>"
+ "<if test='par.areasExpertise!=null'>" + "and b.areas_expertise_code= #{par.areasExpertise}" + "</if>"
+ "<if test='par.name!=null'>" + "and a.name= #{par.name}" + "</if>"
+ "<if test='par.state!=null'>" + "and a.state_code= #{par.state}" + "</if>"
+ "<if test='par.fireTeamId!=null'>" + "and a.fire_team_id= #{par.fireTeamId}" + "</if>"
+ "<if test='par.jobTitle!=null'>" + "and a.job_title_code =#{par.jobTitle}" + "</if>"
+" limit #{pageNum},#{pageSize}"
+ "</script>")	 
List<Firefighters>getFirefighters(@Param("pageNum")int pageNum,@Param("pageSize")int pageSize,@Param("par")FirefightersListVo par);
@Select("<script>"
+ "select COUNT(a.sequence_nbr) num from  cb_firefighters a LEFT JOIN cb_firefighters_post b  on a.sequence_nbr=b.firefighters_id where a.is_delete=0 "
+ "<if test='par.postQualification!=null'>" + "and b.post_qualification_code = #{par.postQualification}" + "</if>"
+ "<if test='par.areasExpertise!=null'>" + "and b.areas_expertise_code= #{par.areasExpertise}" + "</if>"
+ "<if test='par.name!=null'>" + "and a.name= #{par.name}" + "</if>"
+ "<if test='par.state!=null'>" + "and a.state_code= #{par.state}" + "</if>"
+ "<if test='par.fireTeamId!=null'>" + "and a.fire_team_id= #{par.fireTeamId}" + "</if>"
+ "<if test='par.jobTitle!=null'>" + "and a.job_title_code= #{par.jobTitle}" + "</if>"
+ "</script>")	 
Map<String, Long>getFirefightersCount(@Param("pageNum")int pageNum,@Param("pageSize")int pageSize,@Param("par")FirefightersListVo par);

@Select("<script>"
+ "SELECT IFNULL(a.personnel_photos,'') personnelPhotos,	a.sequence_nbr sequenceNbr,IFNULL(a.`name`,'无')`name`,	IFNULL(a.job_title,'无') jobTitle,	IFNULL(b.administrative_position,'无') administrativePosition,	IFNULL(c.`name`,'无') fireTeamName,	IFNULL(a.state,'无') state,	IFNULL(b.employee_hierarchy,'无') employeeHierarchy,	IFNULL(b.areas_expertise,'无') areasExpertise,	IFNULL(a.gender,'无') gender, IFNULL(b.post_qualification,'无') postQualification,year( from_days( datediff( now( ), a.birthday_time))) age  	"
+ " FROM	cb_firefighters a	LEFT JOIN cb_firefighters_post b ON a.sequence_nbr = b.firefighters_id 	LEFT JOIN cb_fire_team c on c.sequence_nbr=a.fire_team_id WHERE a.is_delete =0"
+" and a.sequence_nbr=#{id}"
+ "</script>")
Map<String, Object> listToSelectById(@Param("id")Long  id);
}
