package com.yeejoin.amos.boot.module.jcs.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.jcs.api.vo.*;

import java.util.Collection;
import java.util.List;
import java.util.Map;



/**
 * 机构/部门/人员表 服务类
 *
 * @author tb
 * @date 2021-06-18
 */
public interface IOrgUsrService {
	/**
	 * 查询上级单位
	 * @param parent_id
	 * @return
	 */
    String selectUpUnitByParam(String parent_id);

	/**
	 * 获取父级
	 * @param topId
	 * @param entityList
	 * @param packageURL
	 * @param IDMethodName
	 * @param IDHierarchy
	 * @param NAMEMethodName
	 * @param PARENTIDMethodName
	 * @param OrgTypeMethodName
	 * @return
	 * @throws Exception
	 */
	List<OrgMenuVo> getTree(Long topId, Collection entityList, String packageURL, String IDMethodName, int IDHierarchy,
							String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception;

	/**
	 * 获取子数据集合
	 * @param topId
	 * @param entityList
	 * @param packageURL
	 * @param IDMethodName
	 * @param IDHierarchy
	 * @param NAMEMethodName
	 * @param PARENTIDMethodName
	 * @param OrgTypeMethodName
	 * @return
	 * @throws Exception
	 */
	List<OrgMenuVo> getSub(Long topId, Collection entityList, String packageURL, String IDMethodName, int IDHierarchy,
			String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception;

	/**
	 * 组装融合调度单位人员信息
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	List<Map<String, Object>> returnCompanyPersonMsg(List<Long> ids) throws Exception;

	/**
	 * 获取动态表单数据
	 * @param  id
	 * @return
	 * @throws Exception
	 */
	List<FormValue> getFormValue(Long id) throws Exception;

	/**
	 * 保存 机构/部门/人员基本信息
	 * @param
	 * @throws Exception
	 */
	void saveOrgUsr (OrgUsr oriOrgUsr,Long id) throws Exception;

	/**
	 * 新增机构/部门/人员基本信息和动态表单数据
	 * @param orgUsr
	 * @param alertFromValuelist
	 */
	void saveOrgUsrAlertFormValue (OrgUsr orgUsr,List<AlertFormValue> alertFromValuelist)throws Exception;

	/**
	 * 更新机构/部门/人员基本信息和动态表单数据
	 * @param alertFromValuelist
	 * @throws Exception
	 */
	void updateAlertFormValue(OrgUsr orgUsr,Long alertCalledId,List<AlertFormValue> alertFromValuelist)throws Exception;

	/**
	 *
	 * @param id
	 * @throws Exception
	 */
	Map<String, Object> selectForShowById (OrgUsr orgUsr,Long id) throws Exception;

	List<OrgUsr> selectCompanyDepartmentMsg();

	void saveOrgUsr( OrgUsrVo OrgUsrVo) throws Exception;

	void saveOrgPerson( OrgPersonVo OrgPersonVo) throws Exception;

	void updateByIdOrgUsr(OrgUsrVo OrgUsrVo,Long id) throws Exception;

	void updateByIdOrgPerson(OrgPersonVo OrgPersonVo,Long id) throws Exception;

	OrgUsrFormVo selectCompanyById(Long id) throws Exception;

	IPage bizOrgTypeListPage(String pageNum, String pageSize, String bizOrgType) throws Exception;

	void saveDepartment(List<OrgDepartmentVo> OrgDepartmentVo, Long id)throws Exception;

	void saveCompany(List<OrgUsrVo> OrgUsrVo)throws Exception;

	OrgPersonFormVo selectPersonById(Long id) throws Exception;

	OrgPersonFormVo selectPersonByIdDetail(Long id) throws Exception;

	List<OrgMenuVo> selectPersonTree() throws Exception;

	void savePersonList (List <OrgPersonVo> OrgPersonVo)throws Exception;

	void saveOrgDepartment(OrgDepartmentVo OrgDepartmentVo) throws Exception;

	void updateByIdOrgDepartment ( OrgDepartmentVo OrgDepartmentVo,Long id) throws Exception;

	OrgDepartmentFormVo selectDepartmentById(Long id) throws Exception;

	List<Map<String, Object>>  selectForShowByListId(List<Long> ids) throws Exception;
}
