package com.yeejoin.amos.boot.module.jcs.api.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsrVo", description="机构/部门/人员表")
public class OrgUsrFormVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单位id")
    private Long id;
    @ApiModelProperty(value = "单位id")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "单位名称")
    private String currentUnit;

    @ApiModelProperty(value = "归属机构/部门")
    private String parentId;
    
    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型`")
    private String bizOrgType;

    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;

    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    private Integer personNum;

    @ApiModelProperty(value = "动态表单值")
    private List<FormValue> dynamicFormAlert;

    @ApiModelProperty(value = "单位人员信息值")
    private List<OrgPersonFormVo> children;

    public OrgUsrFormVo() {
    }
}
