package com.yeejoin.amos.boot.module.jcs.biz.controller;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AircraftServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;


/**
* 航空器信息
*
* @author system_generator
* @date 2021-06-29
*/
@RestController
@Api(tags = "航空器信息Api")
@RequestMapping(value = "/aircraft")
public class AircraftController extends BaseController {

    @Autowired
    private AircraftServiceImpl aircraftServiceImpl;

    /**
    * 新增航空器信息
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增航空器信息", notes = "新增航空器信息")
	public ResponseModel<AircraftDto> save(@RequestBody AircraftDto model) throws Exception
	{
    	 if (ValidationUtil.isEmpty(model)
                 || ValidationUtil.isEmpty(model.getAircraftModel()))
             throw new BadRequest("参数校验失败.");
    	 
	    model=aircraftServiceImpl.createAircraft(RequestContext.getAgencyCode(), model);
	    return ResponseHelper.buildResponse(model);
	}
	/**
    * 根据sequenceNbr更新
    * @param sequenceNbr 主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新航空器信息", notes = "根据sequenceNbr更新航空器信息")
	public ResponseModel<AircraftDto> updateBySequenceNbrAircraft(@RequestBody AircraftDto model,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) throws Exception {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(aircraftServiceImpl.updateAircraft(RequestContext.getAgencyCode(), model));
	}
	/**
	 * 
	 * <pre>
	 * 根据物理主键批量删除航空器信息
	 * </pre>
	 *
	 * @param request
	 * @param ids
	 * @return
	 */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{ids}")
    @ApiOperation(httpMethod = "DELETE", value = "根据物理主键批量删除航空器信息", notes = "根据物理主键批量删除航空器信息")
    public ResponseModel<List<Long>> deleteBySequenceNbr(HttpServletRequest request, 
    		@PathVariable(value = "ids") String ids) throws Exception{
    	
        return ResponseHelper.buildResponse(aircraftServiceImpl.multDeleteAircraft(RequestContext.getAgencyCode(), ids));
    }
    /**
    * 根据sequenceNbr查询
    * @param sequenceNbr  主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个航空器信息",  notes = "根据sequenceNbr查询单个航空器信息")
	public ResponseModel<AircraftDto> seleteOne(@PathVariable Long sequenceNbr)
	{
	    return ResponseHelper.buildResponse(aircraftServiceImpl.queryByAircraftSeq(RequestContext.getAgencyCode(), sequenceNbr));
	}
	/**
    * 列表分页查询
    *@param current 当前页
    *@param current 每页大小
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "航空器信息分页查询",  notes = "航空器信息分页查询")
	public ResponseModel<Page<AircraftDto>> queryForPage(
			@RequestParam(value = "aircraftModel", required = false) String aircraftModel,
            @RequestParam(value = "engineType", required = false) String engineType,
            @RequestParam(value = "fuelType", required = false) String fuelType,
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size)
	{
	    Page<AircraftDto> page=new Page<AircraftDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(aircraftServiceImpl.queryForAircraftPage(page, aircraftModel, engineType, fuelType));
	}

}
