package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertForm;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertFormVo;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AlertFormServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


/**
* 警情表单
*
* @author tb
* @date 2021-06-17
*/
@RestController
@Api(tags = "警情表单Api")
@RequestMapping(value = "/alert-form")
public class AlertFormController extends BaseController {

    @Autowired
    AlertFormServiceImpl iAlertFormService;

    @Autowired
    RedisUtils redisUtils;
    @Value("${redis.cache.failure.time}")
    private long time;
    /**
    * 新增警情表单
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增警情表单", notes = "新增警情表单")
    public boolean saveAlertForm(HttpServletRequest request, @RequestBody AlertForm alertForm){
        return iAlertFormService.save(alertForm);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iAlertFormService.removeById(id);
    }




    /**
    * 修改警情表单
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改警情表单", notes = "修改警情表单")
    public boolean updateByIdAlertForm(HttpServletRequest request, @RequestBody AlertForm alertForm){
        return iAlertFormService.updateById(alertForm);
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public AlertForm selectById(HttpServletRequest request, @PathVariable Long id){
        return iAlertFormService.getById(id);
    }



    
    /**
     * 根据表态类型code查询表单数据项
     * @param id
     * @return
     */

     @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
     @RequestMapping(value = "/form/{code}", method = RequestMethod.GET)
     @ApiOperation(httpMethod = "GET", value = "根据表态类型code查询表单数据项", notes = "根据表态类型code查询表单数据项")
     public ResponseModel<Object> selectFormdItem(HttpServletRequest request, @PathVariable String code){
         List<AlertFormVo> list=new ArrayList<AlertFormVo>();
         if(redisUtils.hasKey(RedisKey.FORM_CODE+code)){
             Object obj= redisUtils.get(RedisKey.FORM_CODE+code);
             return ResponseHelper.buildResponse(obj);
         }else{
             list=  iAlertFormService.getFormlist(code);
             redisUtils.set(RedisKey.FORM_CODE+code,JSON.toJSON(list),time);
             return ResponseHelper.buildResponse(list);
         }
     }
    
    
    
    
    
    
    
    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<AlertForm> listPage(String pageNum,String pageSize, AlertForm alertForm){

        Page<AlertForm> pageBean;
        QueryWrapper<AlertForm> alertFormQueryWrapper = new QueryWrapper<>();
        Class<? extends AlertForm> aClass = alertForm.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(alertForm);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(alertForm);
                        alertFormQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(alertForm);
                        alertFormQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(alertForm);
                        alertFormQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(alertForm);
                        alertFormQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw  new RuntimeException("系统异常");
            }
        });
        IPage<AlertForm> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iAlertFormService.page(pageBean, alertFormQueryWrapper);
            return page;
        }
    }

