package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jcs.api.dto.FireSystemDto;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.EquipmentServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 装备服务接口
 *
 * @author DELL
 */
@RestController
@Api(tags = "装备服务Api")
@RequestMapping(value = "/equip")
public class EquipmentController extends BaseController {

    @Autowired
    EquipmentServiceImpl equipmentService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/fireSystem/list")
    @ApiOperation(value = "获取消防系统列表")
    public ResponseModel<List<FireSystemDto>> getFireSystemList() {
        return ResponseHelper.buildResponse(equipmentService.getFireSystemList());
    }
}
