package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.FirefightersThought;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.FirefightersThoughtServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Date;
import java.util.List;


/**
* 消防员思想谈话记录
*
* @author tb
* @date 2021-06-07
*/
@RestController
@Api(tags = "消防员思想谈话记录Api")
@RequestMapping(value = "/firefighters-thought")
public class FirefightersThoughtController extends BaseController {

    @Autowired
    FirefightersThoughtServiceImpl iFirefightersThoughtService;
    @Autowired
    RedisUtils redisUtils;
    @Value("${redis.cache.failure.time}")
    private long time;
    /**
    * 新增消防员思想谈话记录
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增消防员思想谈话记录", notes = "新增消防员思想谈话记录")
    public ResponseModel<FirefightersThought> saveFirefightersThought(HttpServletRequest request, @RequestBody FirefightersThought firefightersThought){
    	iFirefightersThoughtService.save(firefightersThought);
    	return ResponseHelper.buildResponse(firefightersThought);

    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel<Object> deleteById(HttpServletRequest request, @PathVariable String id){
    	String str[] = id.split(",");
   	    List<String> ids= Arrays.asList(str);
     	for (String sequenceNbr : ids) {
        iFirefightersThoughtService.update(new UpdateWrapper<FirefightersThought>().eq("sequence_nbr", Long.valueOf(sequenceNbr)).set("is_delete", 1));
            //删除缓存
            redisUtils.del(RedisKey.THOUGHT_ID+sequenceNbr);
     	}
    	return ResponseHelper.buildResponse(null);

    }




    /** 修改消防员思想谈话记录
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改消防员思想谈话记录", notes = "修改消防员思想谈话记录")
    public ResponseModel<FirefightersThought>  updateByIdFirefightersThought(HttpServletRequest request, @RequestBody FirefightersThought firefightersThought){
    	iFirefightersThoughtService.updateById(firefightersThought);
        //删除缓存
        redisUtils.del(RedisKey.THOUGHT_ID+firefightersThought.getSequenceNbr());
        return ResponseHelper.buildResponse(firefightersThought);

    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据消防员id查询", notes = "根据消防员id查询")
    public ResponseModel<Object> selectById(HttpServletRequest request, @PathVariable Long id){

        if(redisUtils.hasKey(RedisKey.THOUGHT_ID+id)){
            Object obj= redisUtils.get(RedisKey.THOUGHT_ID+id);
            return ResponseHelper.buildResponse(obj);
        }else{
            FirefightersThought firefightersThought= iFirefightersThoughtService.getById(id);
            redisUtils.set(RedisKey.THOUGHT_ID+id, JSON.toJSON(firefightersThought),time);
            return ResponseHelper.buildResponse(firefightersThought);
        }

    }



    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<IPage<FirefightersThought>> listPage(String pageNum,String pageSize, FirefightersThought firefightersThought){

        Page<FirefightersThought> pageBean;
        QueryWrapper<FirefightersThought> firefightersThoughtQueryWrapper = new QueryWrapper<>();
        firefightersThoughtQueryWrapper.eq("is_delete", 0);
        Class<? extends FirefightersThought> aClass = firefightersThought.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(firefightersThought);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(firefightersThought);
                        firefightersThoughtQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(firefightersThought);
                        firefightersThoughtQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(firefightersThought);
                        firefightersThoughtQueryWrapper.eq(name, fileValue);
                    }else if (type.equals(Date.class)) {
                    	Date fileValue = (Date) field.get(firefightersThought);
                    	firefightersThoughtQueryWrapper.eq(name, fileValue);
                    } else {
                    	if(!name.equals(NameUtils.camel2Underline("serialVersionUID"))) {
                        String fileValue = (String) field.get(firefightersThought);
                        firefightersThoughtQueryWrapper.eq(name, fileValue);
                    }}
                }
            } catch (Exception e) {
                throw  new RuntimeException("系统异常");
            }
        });
        IPage<FirefightersThought> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iFirefightersThoughtService.page(pageBean, firefightersThoughtQueryWrapper);

        return ResponseHelper.buildResponse(page); }
    }

