package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.FirefightersWorkexperience;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.FirefightersWorkexperienceServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
* 工作经历
*
* @author tb
* @date 2021-06-07
*/
@RestController
@Api(tags = "工作经历Api")
@RequestMapping(value = "/firefighters-workexperience")
public class FirefightersWorkexperienceController extends BaseController {

    @Autowired
    FirefightersWorkexperienceServiceImpl iFirefightersWorkexperienceService;

    /**
    * 新增工作经历
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增工作经历", notes = "新增工作经历")
    public boolean saveFirefightersWorkexperience(HttpServletRequest request, @RequestBody FirefightersWorkexperience firefightersWorkexperience){
        return iFirefightersWorkexperienceService.save(firefightersWorkexperience);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iFirefightersWorkexperienceService.removeById(id);
    }




    /**
    * 修改工作经历
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改工作经历", notes = "修改工作经历")
    public boolean updateByIdFirefightersWorkexperience(HttpServletRequest request, @RequestBody FirefightersWorkexperience firefightersWorkexperience){
        return iFirefightersWorkexperienceService.updateById(firefightersWorkexperience);
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public FirefightersWorkexperience selectById(HttpServletRequest request, @PathVariable Long id){
        return iFirefightersWorkexperienceService.getById(id);
    }



    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<FirefightersWorkexperience> listPage(String pageNum,String pageSize, FirefightersWorkexperience firefightersWorkexperience){

        Page<FirefightersWorkexperience> pageBean;
        QueryWrapper<FirefightersWorkexperience> firefightersWorkexperienceQueryWrapper = new QueryWrapper<>();
        Class<? extends FirefightersWorkexperience> aClass = firefightersWorkexperience.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(firefightersWorkexperience);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(firefightersWorkexperience);
                        firefightersWorkexperienceQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(firefightersWorkexperience);
                        firefightersWorkexperienceQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(firefightersWorkexperience);
                        firefightersWorkexperienceQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(firefightersWorkexperience);
                        firefightersWorkexperienceQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw  new RuntimeException("系统异常");
            }
        });
        IPage<FirefightersWorkexperience> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iFirefightersWorkexperienceService.page(pageBean, firefightersWorkexperienceQueryWrapper);
            return page;
        }
    }

