package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.yeejoin.amos.boot.module.jcs.api.vo.OrgDepartmentFormVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.utils.ExcelUtils;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgDepartmentVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgUsrDownloadTemplateVO;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AlertFormValueServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.OrgUsrServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author fengwang
 * @date 2021-06-21.
 */
@RestController
@Api(tags = "部门Api")
@RequestMapping(value = "/org-department")
public class OrgDepartmentController {
    @Autowired
    OrgUsrServiceImpl iOrgUsrService;
    @Autowired
    AlertFormValueServiceImpl iAlertFromValueService;

    /**
     * 新增部门信息
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增部门信息", notes = "新增部门信息")
    public ResponseModel<Object> saveOrgUsr(HttpServletRequest request, @RequestBody OrgDepartmentVo OrgDepartmentVo) throws Exception {
    	OrgDepartmentVo.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_DEPARTMENT);
    	iOrgUsrService.saveOrgDepartment(OrgDepartmentVo);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel<Object> deleteById(HttpServletRequest request, @PathVariable Long id) {
        // 删除时，只作逻辑删除
        iOrgUsrService.update(new UpdateWrapper<OrgUsr>().eq("sequence_nbr", id).set("is_delete", CommonConstant.IS_DELETE_01));
        return ResponseHelper.buildResponse(null);
    }


    /**
     * 更新部门数据
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "更新部门数据", notes = "更新部门数据")
    public ResponseModel<Object> updateByIdOrgUsr(HttpServletRequest request, @RequestBody OrgDepartmentVo OrgDepartmentVo, @PathVariable Long id) throws Exception {
    	OrgDepartmentVo.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_DEPARTMENT);
    	iOrgUsrService.updateByIdOrgDepartment(OrgDepartmentVo, id);
        return ResponseHelper.buildResponse(null);
    }


    /**
     * 根据id查询单位
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取部门详情", notes = "获取部门详情")
    public ResponseModel<OrgDepartmentFormVo> selectById(HttpServletRequest request, @PathVariable Long id) throws Exception {
        return ResponseHelper.buildResponse(iOrgUsrService.selectDepartmentById(id));
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<OrgUsr> listPage(String pageNum, String pageSize, OrgUsr orgUsr) {
        Page<OrgUsr> pageBean;
        QueryWrapper<OrgUsr> orgUsrQueryWrapper = new QueryWrapper<>();
        Class<? extends OrgUsr> aClass = orgUsr.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(orgUsr);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<OrgUsr> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iOrgUsrService.page(pageBean, orgUsrQueryWrapper);
        return page;
    }

    /**
     * 导出部门模板
     *
     * @param response
     * @param OrgUsrDownloadTemplateVO
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "download-template", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "导出模板", notes = "导出模板")
    public ResponseModel downloadTemplate(HttpServletResponse response, @RequestBody List<OrgUsrDownloadTemplateVO> OrgUsrDownloadTemplateVO) throws UnsupportedEncodingException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        ExcelUtils.exportExcel(OrgUsrDownloadTemplateVO, "部门信息", "部门信息", OrgUsrDownloadTemplateVO.class, simpleDateFormat.format(new Date()) + ".xls", response);
        return ResponseHelper.buildResponse(null);
    }
}
