package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.yeejoin.amos.boot.module.jcs.api.dto.AlertFromValueDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertFormValueMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertFormValueService;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertFormValueVo;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

/**
*  服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertFormValueServiceImpl extends  BaseService<AlertFromValueDto,AlertFormValue,AlertFormValueMapper>  implements IAlertFormValueService {

	@Autowired
	private AlertFormValueMapper alertFormValueMapper;
	
	public List<AlertFromValueDto> queryByCalledId(Long alertCalledId) {
		return this.queryForList(null, false, alertCalledId);
	}

	public List<AlertFormValueVo> listByCalledId(Long id) {
		return alertFormValueMapper.selectListByCalledId(id);
	}

}
