package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.jcs.api.dto.FireSystemDto;
import com.yeejoin.amos.boot.module.jcs.api.feign.EquipFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;
import java.util.Timer;

/**
 * @author DELL
 */
@Service
public class EquipmentServiceImpl {

    @Autowired
    EquipFeignClient equipFeignClient;

    public List<FireSystemDto> getFireSystemList() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ResponseModel<Object> response = equipFeignClient.getFireSystemListAll();
        stopWatch.stop();
        System.out.printf("耗时%f秒/n", stopWatch.getTotalTimeSeconds());
        List<Map<String, Object>> fireSystemMapList = (List<Map<String, Object>>) response.getResult();
        List<FireSystemDto> fireSystemDtoList = Lists.newArrayList();
        fireSystemMapList.forEach(system -> {
            FireSystemDto fireSystemDto = new FireSystemDto();
            fireSystemDto.setId((String) system.get("id"));
            fireSystemDto.setName((String) system.get("name"));
            fireSystemDtoList.add(fireSystemDto);
        });
        return fireSystemDtoList;
    }
}
