package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.yeejoin.amos.boot.module.jcs.api.dto.FireBrigadeResourceDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.FireTeamDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.jcs.api.mapper.FireTeamMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IFireTeamService;
import com.yeejoin.amos.boot.module.jcs.api.vo.FireTeamListVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.FireTeamVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;

/**
* 消防队伍 服务实现类
*
* @author tb
* @date 2021-06-07
*/
@Service
public class FireTeamServiceImpl extends BaseService<FireTeamDto, FireTeam,FireTeamMapper> implements IFireTeamService {
    
	@Autowired
	FireTeamMapper fireTeamMapper;
	@Override
	public List<FireTeamVo> getFireTeam(int pageNum, int pageSize, FireTeamListVo par) {
		// TODO Auto-generated method stub
		return fireTeamMapper.getFireTeam( pageNum,  pageSize,  par) ;
	}

	@Override
	public Map<String, Long> getFireTeamCount(int pageNum, int pageSize, FireTeamListVo par) {
		// TODO Auto-generated method stub
		return fireTeamMapper.getFireTeamCount( pageNum,  pageSize,  par) ;
	}


	/**
	 * 获取监控大队列表
	 *
	 * @return
	 */
	public List<FireBrigadeResourceDto> listMonitorFireBrigade() {
		return fireTeamMapper.listMonitorFireBrigade();
	}
}
