package com.yeejoin.amos.boot.module.jcs.biz.service.impl;


import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertFromDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertFromValueDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertForm;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.jcs.api.enums.OrgPersonEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertFormValueVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.FormValue;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgDepartmentFormVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgDepartmentVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgMenuVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgPersonFormVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgPersonVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgUsrFormVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgUsrVo;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

/**
 * 机构/部门/人员表 服务实现类
 *
 * @author tb
 * @date 2021-06-18
 */

@Service
public class OrgUsrServiceImpl extends BaseService<OrgUsrDto, OrgUsr, OrgUsrMapper> implements IOrgUsrService {
    @Autowired
    AlertFormValueServiceImpl alertFormValueServiceImpl;
    @Autowired
    AlertFormServiceImpl alertFormServiceImpl;

    @Override
    public String selectUpUnitByParam(String id) {
        return this.baseMapper.selectUpUnitByParam(id);
    }

    @Override
    public List<OrgMenuVo> getTree(Long topId, Collection entityList, String packageURL, String IDMethodName, int IDHierarchy, String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception {
        List<OrgMenuVo> resultList = new ArrayList<>();
        Class<?> clazz = Class.forName(packageURL);
        Method IDMethodNameme = null;
        switch (IDHierarchy) {
            case 1:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
            case 2:
                IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            case 3:
                IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            default:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
        }

        Method NAMEMethodNameme = clazz.getDeclaredMethod(NAMEMethodName);
        Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);
        Method OrgTypeMethodNameme = clazz.getDeclaredMethod(OrgTypeMethodName);
        //获取顶层元素集合
        Long parentId;
        for (Object ob : entityList) {

            Object entity = clazz.cast(ob);

            parentId = PARENTIDMethodNameme.invoke(entity) != null ? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))) : null;

            if (parentId == null || topId == parentId) {
                OrgMenuVo menu = new OrgMenuVo(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId, String.valueOf(OrgTypeMethodNameme.invoke(entity)), false);
                resultList.add(menu);
            }
        }
        //获取每个顶层元素的子数据集合
        for (OrgMenuVo entity : resultList) {
            entity.setChildren(getSub(entity.getKey(), entityList, packageURL, IDMethodName, IDHierarchy, NAMEMethodName, PARENTIDMethodName, OrgTypeMethodName));
        }
        return resultList;
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<OrgMenuVo> getSub(Long topId, @SuppressWarnings("rawtypes") Collection entityList, String packageURL, String IDMethodName, int IDHierarchy, String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception {
        List<OrgMenuVo> childList = new ArrayList<>();
        @SuppressWarnings("rawtypes")
        Class clazz = Class.forName(packageURL);
        Method IDMethodNameme = null;
        switch (IDHierarchy) {
            case 1:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
            case 2:
                IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            case 3:
                IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            default:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
        }
        Method OrgTypeMethodNameme = clazz.getDeclaredMethod(OrgTypeMethodName);
        Method NAMEMethodNameme = clazz.getDeclaredMethod(NAMEMethodName);
        Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);

        Long parentId;
        //子集的直接子对象
        for (Object ob : entityList) {
            Object entity = clazz.cast(ob);

            parentId = PARENTIDMethodNameme.invoke(entity) != null ? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))) : null;

            if (parentId == null) {
                if (topId == parentId) {
                    OrgMenuVo menu = new OrgMenuVo(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId, String.valueOf(OrgTypeMethodNameme.invoke(entity)));
                    childList.add(menu);
                }
            } else {
                if (topId.longValue() == parentId.longValue()) {
                    OrgMenuVo menu = new OrgMenuVo(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId, String.valueOf(OrgTypeMethodNameme.invoke(entity)));
                    childList.add(menu);
                }
            }

        }

        //子集的间接子对象
        for (OrgMenuVo entity : childList) {
            entity.setChildren(getSub(entity.getKey(), entityList, packageURL, IDMethodName, IDHierarchy, NAMEMethodName, PARENTIDMethodName, OrgTypeMethodName));
            if (entity.getChildren() != null) {
                entity.setLeaf(false);
            }
        }

        //递归退出条件
        if (childList.size() == 0) {
            return null;
        }

        return childList;
    }

    @Override
    public List<Map<String, Object>> returnCompanyPersonMsg(List<Long> ids) throws Exception {
        List<Map<String, Object>> companyPersonMsg = new ArrayList<>();
        for (int i = 0; i < ids.size(); i++) {
            Map<String, Object> resultMap = new HashMap<>();
            // 查询出单位基本信息
            OrgUsr company = getById(ids.get(i));
            resultMap.put("id", company.getSequenceNbr());
            // 上级单位
            resultMap.put("upUnit", selectUpUnitByParam(company.getSequenceNbr()+""));
            // 当前单位
            resultMap.put("currentUnit", company.getBizOrgName());
            // 下级单位
            Map<String, Object> downUnitColumnMap = new HashMap<>();
            downUnitColumnMap.put("is_delete", CommonConstant.IS_DELETE_00);
            downUnitColumnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_COMPANY);
            downUnitColumnMap.put("parent_id", company.getSequenceNbr());
            QueryWrapper<OrgUsr> downUnitWrapper = new QueryWrapper<OrgUsr>();
            downUnitWrapper.allEq(downUnitColumnMap);
            List<OrgUsr> downList = list(downUnitWrapper);
            if (downList.size() == 0) {
                resultMap.put("downUnit", false);
            } else {
                resultMap.put("downUnit", true);
            }
            // 人员数量
            Map<String, Object> countPerson = new HashMap<>();
            countPerson.put("parent_id", company.getSequenceNbr());
            countPerson.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_PERSON);
            QueryWrapper<OrgUsr> personNumWrapper = new QueryWrapper<OrgUsr>();
            personNumWrapper.allEq(countPerson);
            int personNum = count(personNumWrapper);
            resultMap.put("personNum", personNum);
            if (0 == personNum) {
            	continue;
            }
            List<Map<String, Object>> personList = new ArrayList<>();
                // 查询动态表单Phone
            Map<String, Object> phone = new HashMap<>();
            phone.put("alert_called_id", company.getSequenceNbr());
            phone.put("field_code", "companyPhone");
            QueryWrapper<AlertFormValue> phoneWrapper = new QueryWrapper<AlertFormValue>();
            phoneWrapper.allEq(phone);
            AlertFormValue phoneValue = alertFormValueServiceImpl.getOne(phoneWrapper);
            if (phoneValue == null) {
            	resultMap.put("tel", "");
            } else {
            	resultMap.put("tel", phoneValue.getFieldValue());
            }
            
            // 获取单位人员列表信息
            personList = listPerson(company.getSequenceNbr()+"").stream().map( p -> {
            	Map<String, Object> person = new HashMap<>();
            	person.put("tel", getValue(p.get("telephone"), null));
            	person.put("img", getValue(p.get("personImg"), null));
            	person.put("id", getValue(p.get("sequenceNbr"), null));
            	person.put("name", getValue(p.get("bizOrgName"), null));
            	person.put("zhiwei", getValue(p.get("administrativePositionCode"), null));
            	person.put("unit", getValue(p.get("fireManagementPostCode"), null));
            	return person;
            }).collect(Collectors.toList());
            resultMap.put("children", personList);
            companyPersonMsg.add(resultMap);
        }
        return companyPersonMsg;
    }
    
    private Object getValue(Object obj, Object defaultValue) {
    	return ObjectUtils.isEmpty(obj) ? defaultValue : obj;
    }
    

    public List<Map<String, Object>> listPerson(String parentId) {
    	Map<String, Object> map = new HashMap<String, Object>();
        map.put("fields", alertFormServiceImpl.queryListByFormId(OrgPersonEnum.人员.getCode()));
        map.put("bizOrgType", OrgPersonEnum.人员.getKey());
        map.put("parentId", parentId);
        List<Map<String, Object>> list = this.baseMapper.selectPersonAllList(map);
        return list == null ? new ArrayList<Map<String, Object>>() : list;
    }
    


    public IPage<Map<String, Object>> pagePerson(String pageNum, String pageSize, Map<String, Object> req) {
        IPage<Map<String, Object>> pageBean = null;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        Map<String, Object> map = new HashMap<>();
        map.put("bizOrgType", OrgPersonEnum.人员.getKey());
        if (!ObjectUtils.isEmpty(req.get("bizOrgName"))) {
        	map.put("bizOrgName", req.get("bizOrgName"));
        }
        OrgUsr parent = this.getById( Long.valueOf(req.get("parentId").toString()));
        map.put("bizOrgCode", ObjectUtils.isEmpty(parent) ? null : parent.getBizOrgCode());
        req.remove("bizOrgName");
        req.remove("pageSize");
        req.remove("pageNum");
        req.remove("parentId");
        map.put("fieldsValue", req);
        map.put("fields", alertFormServiceImpl.queryListByFormId(OrgPersonEnum.人员.getCode()));
        pageBean.setTotal(this.baseMapper.selectPersonListCount(map));
        map.put("pageNum", (pageBean.getCurrent() - 1) * pageBean.getSize());
        map.put("pageSize", pageBean.getSize());
        
        List<Map<String, Object>> list = this.baseMapper.selectPersonList(map);

        pageBean.setRecords(list);
        return pageBean;
    }

    @Override
    public List<FormValue> getFormValue(Long id) throws Exception {
        // 动态表单数据
        List<AlertFormValueVo> list = alertFormValueServiceImpl.listByCalledId(id);
        List<FormValue> formValue = new ArrayList<>();
        for (AlertFormValueVo alertFormValue : list) {
            if (alertFormValue.getFieldValueCode() == null) {
                FormValue value = new FormValue(alertFormValue.getFieldCode(), alertFormValue.getFieldName(), alertFormValue.getFieldType(),
                        alertFormValue.getFieldValue(), alertFormValue.getBlock());
                formValue.add(value);
            } else {
                FormValue value = new FormValue(alertFormValue.getFieldCode(), alertFormValue.getFieldName(), alertFormValue.getFieldType(),
                        alertFormValue.getFieldValueCode(), alertFormValue.getBlock());
                formValue.add(value);
            }
        }
        return formValue;
    }

    public List<FormValue> getFormValueDetail(Long id) throws Exception {
        // 动态表单数据
        List<AlertFormValueVo> list = alertFormValueServiceImpl.listByCalledId(id);
        List<FormValue> formValue = new ArrayList<>();
        for (AlertFormValueVo alertFormValue : list) {
            FormValue value = new FormValue(alertFormValue.getFieldCode(), alertFormValue.getFieldName(), alertFormValue.getFieldType(),
                    alertFormValue.getFieldValue(), alertFormValue.getBlock());
            formValue.add(value);
        }
        return formValue;
    }

    @Override
    public void saveOrgUsr(OrgUsr oriOrgUsr, Long id) throws Exception {
        OrgUsr orgUsr = new OrgUsr();
        OrgUsr ori = getById(id);
        orgUsr.setSequenceNbr(id);
        orgUsr.setRecDate(new Date());
        orgUsr.setRecUserId(ori.getRecUserId());
        orgUsr.setRecUserName(ori.getRecUserName());
        orgUsr.setAmosOrgId(ori.getAmosOrgId());
        orgUsr.setAmosOrgCode(ori.getAmosOrgCode());
        
        if (oriOrgUsr.getParentId() != null) {
        	if (!ori.getParentId().equals(oriOrgUsr.getParentId())) {
        		OrgUsr parent = getById(oriOrgUsr.getParentId());
                if (parent != null && ObjectUtils.isEmpty(oriOrgUsr.getBizOrgCode())) {
                	orgUsr.setBizOrgCode(parent.getBizOrgCode() + getOrgCodeStr());
                }
                updateChildOrgCode(ori.getBizOrgCode(), parent.getBizOrgCode());
                orgUsr.setParentId(oriOrgUsr.getParentId());
        	}
        } else {
        	orgUsr.setBizOrgCode(getOrgCodeStr());
        	updateChildOrgCode(ori.getBizOrgCode(), orgUsr.getBizOrgCode());
        }
        updateById(orgUsr);
    }
    
    
    private void updateChildOrgCode(String oriOrgCode, String targetOrgCode) {
    	List<OrgUsr> list = queryOrgUsrList(oriOrgCode);
    	if (ObjectUtils.isEmpty(list)) {
    		return;
    	}
    	list.forEach(action -> {
    		action.setBizOrgCode(action.getBizOrgCode().replace(oriOrgCode, targetOrgCode));
    		updateById(action);
    	});
    }
    
    public List<OrgUsr> queryOrgUsrList(String bizOrgCode) {
    	return this.baseMapper.queryOrgUsrListByBizOrgCode(bizOrgCode);
    }

    @Override
    public void saveOrgUsrAlertFormValue(OrgUsr orgUsr, List<AlertFormValue> alertFromValuelist) {
    	orgUsr.setRecDate(new Date());
    	AgencyUserModel user = Privilege.agencyUserClient.getme().getResult();
    	orgUsr.setRecUserName(user.getRealName());
    	orgUsr.setRecUserId(user.getUserId());
        // 单位新增情况
        save(orgUsr);
        // 填充主键
        alertFromValuelist.stream().forEach(alertFromValue -> {
        	if (OrgPersonEnum.公司.getKey().equals(orgUsr.getBizOrgType())) {
        		alertFromValue.setAlertTypeCode(OrgPersonEnum.公司.getCode());
        	} else if (OrgPersonEnum.部门.getKey().equals(orgUsr.getBizOrgType())) {
        		alertFromValue.setAlertTypeCode(OrgPersonEnum.部门.getCode());
        	}
            alertFromValue.setAlertCalledId(orgUsr.getSequenceNbr());
        });
        // 保存动态表单数据
        alertFormValueServiceImpl.saveBatch(alertFromValuelist);
    }

    @Override
    public void updateAlertFormValue(OrgUsr orgUsr, Long alertCalledId, List<AlertFormValue> alertFromValuelist) throws Exception {
        // 填充主键
        alertFromValuelist.stream().forEach(alertFromValue -> {
            alertFromValue.setAlertCalledId(orgUsr.getSequenceNbr());
        });
        List<AlertFromValueDto> formList = alertFormValueServiceImpl.queryByCalledId(orgUsr.getSequenceNbr());
        if (formList != null && formList.size() > 0) {
        	for (AlertFormValue dis : alertFromValuelist) {
                for (AlertFromValueDto src : formList) {
                    if (dis.getAlertFormId() == src.getAlertFormId()) {
                        dis.setSequenceNbr(src.getSequenceNbr());
                        dis.setRecDate(new Date());
                        dis.setRecUserId(orgUsr.getRecUserId());
                        dis.setRecUserName(orgUsr.getRecUserName());
                        dis.setAlertTypeCode(src.getAlertTypeCode());
                        dis.setAlertFormId(src.getAlertFormId());
                        dis.setSequenceNbr(src.getSequenceNbr());
                        break;
                    }
                }
            }
        	// 保存动态表单数据
            alertFormValueServiceImpl.updateBatchById(alertFromValuelist);
            
            List<AlertFromDto> form = alertFormServiceImpl.queryListByTypeCode(formList.get(0).getAlertTypeCode());
            
            if (form.size() != alertFromValuelist.size()) {
            	
            	List<AlertFormValue> creatList = new ArrayList<>();
            	
            	for (AlertFormValue dis : alertFromValuelist) {
            		boolean exist = false;
            		for (AlertFromValueDto src : formList) {
                        if (dis.getAlertFormId() == src.getSequenceNbr()) {
                        	exist = true;
                            break;
                        }
                    }
            		if (ObjectUtils.isEmpty(dis) && !exist) {
            			creatList.add(dis);
            		}
                }
            	
            	alertFormValueServiceImpl.saveBatch(creatList);
            }
            
            List<AlertFormValue> creatList = alertFromValuelist.stream().filter(v -> v.getSequenceNbr() == null || v.getSequenceNbr() == 0).collect(Collectors.toList());
            if (creatList != null && creatList.size() > 0) {
            	alertFormValueServiceImpl.saveBatch(creatList);
            }
        } else {
            // 保存动态表单数据
            alertFormValueServiceImpl.saveBatch(alertFromValuelist);
        }
    }

    @Override
    public Map<String, Object> selectForShowById(OrgUsr orgUsr, Long id) throws Exception {
        QueryWrapper<AlertForm> queryWrapper = new QueryWrapper<AlertForm>();
        queryWrapper.eq("alert_type_code",OrgPersonEnum.人员.getCode());
        List<AlertForm> alertForms = alertFormServiceImpl.list(queryWrapper);
        // 动态表单数据
        List<AlertFormValueVo> list = alertFormValueServiceImpl.listByCalledId(id);
        Map<String, Object> result = new HashMap<>();
        result = Bean.BeantoMap(orgUsr);
        result.put("parenName",getById(orgUsr.getParentId()).getBizOrgName());
        // 放入所有动态表单数据
        for (AlertForm alertForm : alertForms) {
            result.put(alertForm.getFieldCode(), null);
        }
        for (AlertFormValueVo alertFormValue : list) {
            result.replace(alertFormValue.getFieldCode(), alertFormValue.getFieldValue());
        }
        return result;
    }

    @Override
    public List<OrgUsr> selectCompanyDepartmentMsg() {
        return this.baseMapper.selectCompanyDepartmentMsg();
    }

    @Override
    public void saveOrgUsr(OrgUsrVo OrgUsrVo) throws Exception {
        OrgUsr orgUsr = new OrgUsr();
        BeanUtils.copyProperties(OrgUsrVo, orgUsr);
        orgUsr.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_COMPANY);
        if (OrgUsrVo.getParentId() != null) {
        	OrgUsr parent = getById(OrgUsrVo.getParentId());
            if (parent != null &&  ObjectUtils.isEmpty(OrgUsrVo.getBizOrgCode())) {
            	orgUsr.setBizOrgCode(parent.getBizOrgCode() + getOrgCodeStr());
            }
        } else {
        	orgUsr.setBizOrgCode(getOrgCodeStr());
        }
        saveOrgUsrAlertFormValue(orgUsr, OrgUsrVo.getAlertFormValue());
    }

    @Override
    public void saveOrgPerson(OrgPersonVo OrgPersonVo) throws Exception {
        OrgUsr orgUsr = new OrgUsr();
        BeanUtils.copyProperties(OrgPersonVo, orgUsr);
        orgUsr.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_PERSON);
        if (OrgPersonVo.getParentId() != null) {
        	OrgUsr parent = getById(OrgPersonVo.getParentId());
            if (parent != null &&  ObjectUtils.isEmpty(OrgPersonVo.getBizOrgCode())) {
            	orgUsr.setBizOrgCode(parent.getBizOrgCode() + getOrgCodeStr());
            }
        } else {
        	orgUsr.setBizOrgCode(getOrgCodeStr());
        }
        
        
        if (!ObjectUtils.isEmpty(OrgPersonVo.getAmosOrgId())) {
        	AgencyUserModel user = Privilege.agencyUserClient.queryByUserId(OrgPersonVo.getAmosOrgId()).getResult();
            OrgPersonVo.setAmosOrgCode(user.getRealName());
        }
        
        saveOrgUsrAlertFormValue(orgUsr, OrgPersonVo.getAlertFormValue());
    }

    @Override
    public void updateByIdOrgUsr(OrgUsrVo OrgUsrVo, Long id) throws Exception {
        // 修改单位信息
        OrgUsr orgUsr = new OrgUsr();
        OrgUsr oriOrgUsr = getById(id);
        BeanUtils.copyProperties(OrgUsrVo, orgUsr);
        if (orgUsr.getParentId() != null) {
        	OrgUsr parent = getById(orgUsr.getParentId());
            if (parent != null &&  ObjectUtils.isEmpty(OrgUsrVo.getBizOrgCode())) {
            	orgUsr.setBizOrgCode(parent.getBizOrgCode() + getOrgCodeStr());
            }
        } else {
        	orgUsr.setBizOrgCode(getOrgCodeStr());
        }
        saveOrgUsr(orgUsr, id);
        // 保存动态表单数据
        updateAlertFormValue(oriOrgUsr, orgUsr.getSequenceNbr(), OrgUsrVo.getAlertFormValue());
    }

    @Override
    public void updateByIdOrgPerson(OrgPersonVo OrgPersonVo, Long id) throws Exception {
        // 修改人员信息
        OrgUsr orgUsr = new OrgUsr();
        OrgUsr oriOrgUsr = getById(id);
        BeanUtils.copyProperties(OrgPersonVo, orgUsr);
        if (!ObjectUtils.isEmpty(OrgPersonVo.getAmosOrgId())) {
        	AgencyUserModel user = Privilege.agencyUserClient.queryByUserId(OrgPersonVo.getAmosOrgId()).getResult();
            oriOrgUsr.setAmosOrgCode(user.getRealName());
            oriOrgUsr.setAmosOrgId(user.getUserId());
            orgUsr.setAmosOrgCode(user.getRealName());
            orgUsr.setAmosOrgId(user.getUserId());
        }
        
        saveOrgUsr(oriOrgUsr, id);
        // 保存动态表单数据
        updateAlertFormValue(oriOrgUsr, orgUsr.getSequenceNbr(), OrgPersonVo.getAlertFormValue());
    }

    @Override
    public OrgUsrFormVo selectCompanyById(Long id) throws Exception {
        OrgUsr orgUsr = getById(id);
        // 动态表单数据
        List<FormValue> formValue = getFormValue(id);
        OrgUsrFormVo orgUsrFormVo = new OrgUsrFormVo();
        orgUsrFormVo.setDynamicFormAlert(formValue);
        BeanUtils.copyProperties(orgUsr, orgUsrFormVo);
        return orgUsrFormVo;
    }

    @Override
    public IPage<OrgUsr> bizOrgTypeListPage(String pageNum, String pageSize, String bizOrgType) throws Exception {

        Map<String, Object> columnMap = new HashMap<>();
        columnMap.put("is_delete", CommonConstant.IS_DELETE_00);
        columnMap.put("biz_org_type", bizOrgType);
        Page<OrgUsr> pageBean = new Page<OrgUsr>();
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        QueryWrapper<OrgUsr> queryWrapper = new QueryWrapper<OrgUsr>();
        queryWrapper.allEq(columnMap);
        queryWrapper.orderByAsc("sequence_nbr");
        return page(pageBean, queryWrapper);
    }

    @Override
    public void saveDepartment(List<OrgDepartmentVo> OrgDepartmentVo, Long id) throws Exception {
        for (int i = 0; i < OrgDepartmentVo.size(); i++) {
            // 导入部门信息的前提条件：单位信息已经存在
            if (getById(id) != null) {
                OrgUsr orgUsr = new OrgUsr();
                BeanUtils.copyProperties(OrgDepartmentVo.get(i), orgUsr);
                orgUsr.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_DEPARTMENT);
                saveOrgUsrAlertFormValue(orgUsr, OrgDepartmentVo.get(i).getAlertFormValue());
            }
        }
    }

    @Override
    public void saveCompany(List<OrgUsrVo> OrgUsrVo) throws Exception {
        for (int i = 0; i < OrgUsrVo.size(); i++) {
            OrgUsr orgUsr = new OrgUsr();
            BeanUtils.copyProperties(OrgUsrVo.get(i), orgUsr);
            orgUsr.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_COMPANY);
            saveOrgUsrAlertFormValue(orgUsr, OrgUsrVo.get(i).getAlertFormValue());
        }
    }

    @Override
    public OrgPersonFormVo selectPersonById(Long id) throws Exception {
        OrgUsr orgUsr = getById(id);
        // 动态表单数据
        List<FormValue> formValue = getFormValue(id);
        OrgPersonFormVo orgPersonFormVo = new OrgPersonFormVo(formValue);
        BeanUtils.copyProperties(orgUsr, orgPersonFormVo);
        orgPersonFormVo.setParentName(getById(orgUsr.getParentId()).getBizOrgName());
        return orgPersonFormVo;
    }

    @Override
    public OrgPersonFormVo selectPersonByIdDetail(Long id) throws Exception {
        OrgUsr orgUsr = getById(id);
        // 动态表单数据
        List<FormValue> formValue = getFormValueDetail(id);
        OrgPersonFormVo orgPersonFormVo = new OrgPersonFormVo(formValue);
        BeanUtils.copyProperties(orgUsr, orgPersonFormVo);
        orgPersonFormVo.setParentName(getById(orgUsr.getParentId()).getBizOrgName());
        return orgPersonFormVo;
    }


    @Override
    public List<OrgMenuVo> selectPersonTree() throws Exception {
        Map<String, Object> columnMap = new HashMap<>();
        columnMap.put("is_delete", CommonConstant.IS_DELETE_00);
        columnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_PERSON);
        Collection<OrgUsr> list = listByMap(columnMap);
        return getTree(null, list, OrgUsr.class.getName(), "getSequenceNbr", 2, "getBizOrgName", "getParentId", "getBizOrgType");
    }


    @Override
    public void savePersonList(List<OrgPersonVo> OrgPersonVo) throws Exception {
        for (int i = 0; i < OrgPersonVo.size(); i++) {
            OrgUsr orgUsr = new OrgUsr();
            BeanUtils.copyProperties(OrgPersonVo.get(i), orgUsr);
            orgUsr.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_PERSON);
            saveOrgUsrAlertFormValue(orgUsr, OrgPersonVo.get(i).getAlertFormValue());
        }
    }

    @Override
    public void saveOrgDepartment(OrgDepartmentVo OrgDepartmentVo) throws Exception {
        OrgUsr orgUsr = new OrgUsr();
        BeanUtils.copyProperties(OrgDepartmentVo, orgUsr);
        orgUsr.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_DEPARTMENT);
        if (OrgDepartmentVo.getParentId() != null) {
        	OrgUsr parent = getById(OrgDepartmentVo.getParentId());
            if (parent != null &&  ObjectUtils.isEmpty(OrgDepartmentVo.getBizOrgCode())) {
            	orgUsr.setBizOrgCode(parent.getBizOrgCode() + getOrgCodeStr());
            }
        } else {
        	orgUsr.setBizOrgCode(getOrgCodeStr());
        }
        saveOrgUsrAlertFormValue(orgUsr, OrgDepartmentVo.getAlertFormValue());
    }

    @Override
    public void updateByIdOrgDepartment(OrgDepartmentVo OrgDepartmentVo, Long id) throws Exception {
        // 修改部门信息
        OrgUsr orgUsr = new OrgUsr();
        OrgUsr oriOrgUsr = getById(id);
        BeanUtils.copyProperties(OrgDepartmentVo, orgUsr);
        if (orgUsr.getParentId() != null) {
        	OrgUsr parent = getById(orgUsr.getParentId());
            if (parent != null &&  ObjectUtils.isEmpty(OrgDepartmentVo.getBizOrgCode())) {
            	orgUsr.setBizOrgCode(parent.getBizOrgCode() + getOrgCodeStr());
            }
        } else {
        	orgUsr.setBizOrgCode(getOrgCodeStr());
        }
        saveOrgUsr(orgUsr, id);
        // 保存动态表单数据
        updateAlertFormValue(oriOrgUsr, orgUsr.getSequenceNbr(), OrgDepartmentVo.getAlertFormValue());
    }

    @Override
    public OrgDepartmentFormVo selectDepartmentById(Long id) throws Exception {
        OrgUsr orgUsr = getById(id);
        // 动态表单数据
        List<FormValue> formValue = getFormValue(id);
        OrgDepartmentFormVo orgDepartmentFormVo = new OrgDepartmentFormVo(formValue);
        BeanUtils.copyProperties(orgUsr, orgDepartmentFormVo);
        return orgDepartmentFormVo;
    }

    @Override
    public List<Map<String, Object>> selectForShowByListId(List<Long> ids) throws Exception {
        List<Map<String, Object>> personResult = new ArrayList<>();
        for (int i = 0; i < ids.size(); i++) {
            OrgUsr orgUsr = getById(ids.get(i));
            Map<String, Object> result = selectForShowById(orgUsr, ids.get(i));
            personResult.add(result);
        }
        return personResult;
    }
    
    public static String getOrgCodeStr(){
		 int length = 6;
	     String str="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	     Random random=new Random();
	     StringBuffer sb=new StringBuffer();
	     for(int i=0;i<length;i++){
	       int number=random.nextInt(62);
	       sb.append(str.charAt(number));
	     }
	     return sb.toString();
	 }
}
