package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledRo;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertCalledVo;
import com.yeejoin.amos.component.rule.RuleTrigger;

/**
 * 
 * <pre>
 * 规则触发服务
 * </pre>
 *
 * @author gwb
 * @version $Id: RuleAlertCalledService.java, v 0.1 2021年6月24日 下午6:30:44 gwb Exp $
 */
@Service
public class RuleAlertCalledService {

	@Autowired
	private RuleTrigger ruleTrigger;

    /**
     * 
     * <pre>
     * 触发警情报送规则
     * </pre>
     *
     * @param alertCalled
     * @return
     * @throws Exception
     */
	public Boolean fireAlertCalledRule(AlertCalledVo alertCalledVo) throws Exception 
    {
    	AlertCalled alertCalled = alertCalledVo.getAlertCalled();
    	if (ValidationUtil.isEmpty(alertCalled))
		{
    		throw new BadRequest("参数校验失败.");
		}
    	/**
    	 * 构建警情报送规则对象
    	 */
    	AlertCalledRo alertCalledRo = new AlertCalledRo();
    	//通用属性
    	alertCalledRo.setSequenceNbr(String.valueOf(alertCalled.getSequenceNbr()));
    	alertCalledRo.setAddress(alertCalled.getAddress());
    	alertCalledRo.setAlertType(alertCalled.getAlertType());
    	alertCalledRo.setAlertTypeCode(alertCalled.getAlertTypeCode());
    	alertCalledRo.setCasualtiesNum(alertCalled.getCasualtiesNum() != null ? String.valueOf(alertCalled.getCasualtiesNum()) : "无");
    	alertCalledRo.setTrappedNum(alertCalled.getTrappedNum() != null ? String.valueOf(alertCalled.getTrappedNum()) : "无");
    	alertCalledRo.setCompanyName(alertCalled.getCompanyName());

    	List<AlertFormValue> alertFormValues = alertCalledVo.getAlertFormValue();
    	if (!ValidationUtil.isEmpty(alertFormValues))
		{
    		for (AlertFormValue alertFormValue : alertFormValues)
    		{
    			if (alertFormValue.getFieldCode().equals("alertSubmittedId"))
    			{
    				alertCalledRo.setAlertSubmittedId(alertFormValue.getFieldValue());
    			}
    			//一般火灾
    			if (alertFormValue.getFieldCode().equals("fireLocation"))
    			{
    				alertCalledRo.setFireLocation(alertFormValue.getFieldValue());
    			}
    			if (alertFormValue.getFieldCode().equals("burningMaterial"))
    			{
    				alertCalledRo.setBurningMaterial(alertFormValue.getFieldValue());
    			}
    			if (alertFormValue.getFieldCode().equals("fireSituation"))
    			{
    				alertCalledRo.setFireSituation(alertFormValue.getFieldValue());
    			}
    			if (alertFormValue.getFieldCode().equals("dangerousExplosives"))
    			{
    				alertCalledRo.setDangerousExplosives(alertFormValue.getFieldValue());
    			}
				if (alertFormValue.getFieldCode().equals("fireTime"))
				{
					alertCalledRo.setCallTimeStr(alertFormValue.getFieldValue());
				}
    			//航空器救援
    			
    			//突发事件救援
    			
    			//漏油现场安全保障
    			
    			//专机保障
    			
    		}
		}
    	
    	//触发规则
    	ruleTrigger.publish(alertCalledRo, "西咸机场119接处警规则/alertCalledRule", new String[0]);

    	return true;
    }

}
