package com.yeejoin.amos.boot.module.jcs.biz.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.jcs.api.dto.FireExpertsDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.FireExperts;

import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;

/**
 * @title: 实体类 Dto，Vo，entity 转换工具类
 * @Author fpy
 * @Date: 2021/6/3 13:53
 */
@Component
public class BeanDtoVoUtils {

    /**
     * Dot ,Vo ,Entity 相互转换
     *
     * @param source      原数据
     * @param targetClass 目标类
     * @param <T>         泛型类
     * @return 转换返回值
     */
    public static <T> T convert(Object source, Class<T> targetClass) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        // 判断targetClass是否为空
        if (targetClass == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            T target = targetClass.newInstance();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            // 返回新对象
            return target;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * Dot ,Vo ,Entity 相互转换
     *
     * @param source 原数据
     * @return 转换返回值
     */
    public static FireExpertsDto convertFireExperts(FireExperts source) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            FireExpertsDto target = FireExpertsDto.class.newInstance();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            // 计算年龄
            int age = getAge(source.getBirthdayTime());
            target.setAge(age);
            // 返回新对象
            return target;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * IPage<Entity> 分页对象转 Page<Dto>
     *
     * @param page 原分页对象
     * @param v    目标vo类
     * @param <E>  泛型类
     * @param <V>  泛型类
     * @return 转换后的分页对象
     */
    public static <E, V> IPage<V> iPageDtoStream(IPage<E> page, Class<V> v) {
        return page.convert(item -> {
            try {
                return convert(item, v);
            } catch (Exception e) {
                return null;
            }
        });
    }

    /**
     * IPage<Entity> 分页对象转 Page<Dto>
     *
     * @param page 原分页对象
     * @return 转换后的分页对象
     */
    public static IPage<FireExpertsDto> iPageDtoStreamFireExperts(IPage<FireExperts> page) {
        return page.convert(item -> {
            try {
                return convertFireExperts(item);
            } catch (Exception e) {
                return null;
            }
        });
    }

    //由出生日期获得年龄
    public static int getAge(Date birthDay) {
        Calendar cal = Calendar.getInstance();

        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("出生日期小于当前时间，无效的日期!");
        }
        int yearNow = cal.get(Calendar.YEAR);
        int monthNow = cal.get(Calendar.MONTH);
        int dayOfMonthNow = cal.get(Calendar.DAY_OF_MONTH);
        cal.setTime(birthDay);

        int yearBirth = cal.get(Calendar.YEAR);
        int monthBirth = cal.get(Calendar.MONTH);
        int dayOfMonthBirth = cal.get(Calendar.DAY_OF_MONTH);

        int age = yearNow - yearBirth;

        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) age--;
            } else {
                age--;
            }
        }
        return age;
    }

}