package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 安全追溯-游乐设施
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("6000")
public class RidesTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "trackHeight", label = "轨道高度", equCategory = {"6B00", "6300", "6200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal trackHeight;


    @TechnicalParameter(key = "runningSpeed", label = "运行速度", equCategory = {"6B00", "6300", "6100", "6700", "6800", "6500", "6200", "6600", "6400", "6E00", "6D00"}, equDefine = {"6D10", "6D20", "6D40", "6E40"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "km/h (m/s)")
    private BigDecimal runningSpeed;


    @TechnicalParameter(key = "numberOfPassengers", label = "承载人数", equCategory = {"6B00", "6A00", "6300", "6900", "6100", "6700", "6800", "6500", "6200", "6600", "6400", "6E00", "6D00"}, equDefine = {"6E40", "6E50", "6D10", "6D40"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "人")
    private BigDecimal numberOfPassengers;


    @TechnicalParameter(key = "slideLength", label = "滑索(道)/蹦极绳长度", equCategory = {"6B00", "6E00"}, equDefine = {"6E40","6E10"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal slideLength;


    @TechnicalParameter(key = "operatingHeight", label = "运行高度", equCategory = {"6500", "6E00", "6D00", "6D00"}, equDefine = {"6D10", "6D20", "6E10", "6E40"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal operatingHeight;


    @TechnicalParameter(key = "slideHeight", label = "蹦极绳高度", equCategory = {"6E00"}, equDefine = {"6E10"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal slideHeight;


    @TechnicalParameter(key = "rotaryDiameter", label = "回转直径", equCategory = {"6100", "6700", "6500", "6600", "6400", "6E00"}, equDefine = {"6E50"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal rotaryDiameter;


    @TechnicalParameter(key = "unilateralSwingAngle", label = "单边摆角", equCategory = {"6E00"}, equDefine = {"6E50"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "°")
    private BigDecimal unilateralSwingAngle;


    @TechnicalParameter(key = "numberOfVehicles", label = "车辆数", equCategory = {"6A00"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "个")
    private BigDecimal numberOfVehicles;


    @TechnicalParameter(key = "dip", label = "倾角", equCategory = {"6400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "°")
    private BigDecimal dip;


    @TechnicalParameter(key = "equipmentHeight", label = "设备高度", equCategory = {"6100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal equipmentHeight;

}
