package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 设备施工告知信息
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialConstructionInfoModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备全省唯一编号
     */
    private String sequenceCode;
    /**
     * 告知单ID
     */
    private String infoId;
    /**
     * 施工类别
     */
    private String constructCategory;
    /**
     * 设备名称
     */
    private String equName;
    /**
     * 告知单编号
     */
    private String infoCode;
    /**
     * 注册登记机构
     */
    private String registerOrg;
    /**
     * 签收日期
     */
    private String signDate;
    /**
     * 设备地点
     */
    private String equAddress;
    /**
     * 设备注册代码
     */
    private String equRegisterCode;
    /**
     * 设备型号
     */
    private String equType;
    /**
     * 出厂编号
     */
    private String factoryCode;
    /**
     * 设备所在地区代码
     */
    private String equRegionCode;
    /**
     * 设备代码
     */
    private String equCode;
    /**
     * 设备制造单位名称
     */
    private String equManufactureUnitName;
    /**
     * 许可证编号
     */
    private String equLicenceNum;
    /**
     * 安装改造维修日期
     */
    private String installReformRepairDate;
    /**
     * 安装竣工日期
     */
    private String installCompletedDate;
    /**
     * 施工单位
     */
    private String constructUnit;
    /**
     * 施工单位ID
     */
    private String constructUnitId;
    /**
     * 许可证编号（或受理编号）
     */
    private String constructLicenceNum;
    /**
     * 施工单位社会信用代码
     */
    private String constructUnitCreditCode;
    /**
     * 施工单位联系人
     */
    private String constructUnitContacts;
    /**
     * 施工单位邮编
     */
    private String constructUnitCode;
    /**
     * 施工单位电话
     */
    private String constructUnitPhone;
    /**
     * 施工单位传真
     */
    private String constructUnitFax;
    /**
     * 施工单位地址
     */
    private String constructUnitAddress;
    /**
     * 许可证有效期
     */
    private String constructLicenceValidity;
    /**
     * 使用单位名称
     */
    private String useUnitName;
    /**
     * 使用单位系统ID
     */
    private String useUnitSystemId;
    /**
     * 使用单位社会信用代码
     */
    private String useUnitCreditCode;
    /**
     * 使用单位联系人
     */
    private String useUnitContacts;
    /**
     * 使用单位电话
     */
    private String useUnitPhone;
    /**
     * 使用单位传真
     */
    private String useUnitFax;
    /**
     * 使用单位地址
     */
    private String useUnitAddress;
    /**
     * 使用单位邮编
     */
    private String useUnitCode;
    /**
     * 告知日期
     */
    private String infoDate;
    /**
     * 注册状态
     */
    private String registerState;
    /**
     * 使用状态
     */
    private String useState;

}
