package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * 液化气体气瓶充装信息-充装后复查
 * @author kinky
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_cylinder_filling_check")
public class CylinderFillingCheck  extends AbstractBaseEntity{/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
		
	@TableField("filling_check_id")
	private String fillingCheckId;	//充装后复查ID

	@TableField("within_scope")
	private int withinScope;	//充装量在规定范围内*
	@TableField("sealed_state")
	private int sealedState;	//瓶阀及其与瓶口连接的密封良好*
	@TableField("defective")
	private int defective;	//瓶体未出现鼓包变形或泄露等严重缺陷*
	@TableField("abnormal_temperature")
	private int abnormalTemperature;	//瓶体温度没有异常升高的迹象*
	@TableField("warning_sign")
	private int warningSign;	//气瓶粘贴警示标签和充装标签*
	@TableField("compliance")
	private String compliance;	//液化气瓶充装量符合有关规定，充装后逐瓶称重
	@TableField("inspector")
	private String inspector;	//检查人员姓名*
	@TableField("inspection_date")
	private String inspectionDate;	//检查时间*
	@TableField("check_results")
	private String checkResults;
	@TableField("nonconformances")
	private String nonconformances;
}
