package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 警情接警填报记录
 *
 * @author litw
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AlertCalledDto", description="警情接警填报记录")
public class AlertCalledDto  extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "警情状态 (0 未结案 1 结案)")
    private Boolean alertStatus;

    @ApiModelProperty(value = "警情状态 结案/ 未结案")
    private String alertStatusStr;

    @ApiModelProperty(value = "警情来源类型")
    private String alertSource;

    @ApiModelProperty(value = "警情来源类型code")
    private String alertSourceCode;

    @ApiModelProperty(value = "接警时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date callTime;

    @ApiModelProperty(value = "报警人电话")
    private String emergencyCall;

    @ApiModelProperty(value = "报警人名称，默认为先生或女士")
    private String emergencyPerson;

    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "设备分类，字典表数据")
    private String equipmentClassification;

    @ApiModelProperty(value = "报警类型")
    private String type;

    @ApiModelProperty(value = "警情类别")
    private String alarmType;

    @ApiModelProperty(value = "通话记录信息id")
    private Integer callRecordId;

    @ApiModelProperty(value = "警情阶段")
    private String alertStage;

    @ApiModelProperty(value = "父警情id")
    private Long fatherAlert;

    @ApiModelProperty(value = "设备识别码")
    private String deviceId;

    @ApiModelProperty(value = "注册编码")
    private String registrationCode;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "设备分类code")
    private String equipmentClassificationCode;

    @ApiModelProperty(value = "报警类型code")
    private String typeCode;

    @ApiModelProperty(value = "警情类别code")
    private String alarmTypeCode;

    @ApiModelProperty(value = "警情阶段code")
    private String alertStageCode;

    @ApiModelProperty(value = "组织机构")
    private String bizOrgCode;

    @ApiModelProperty(value = "使用单位")
    private String useUnit;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "接警时间开始---用于列表过滤")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date callTimeStart ;

    @ApiModelProperty(value = "接警时间结束---用于列表过滤")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date callTimeEnd ;

    @ApiModelProperty(value = "是否处警")
    private Boolean isFatherAlert = false;

    @ApiModelProperty(value = "所属省")
    private String province;

    @ApiModelProperty(value = "所属地市")
    private String city;

    @ApiModelProperty(value = "所属区县")
    private String district;

    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    @ApiModelProperty(value = "使用场所分类")
    private String useSiteCategory;

    @ApiModelProperty(value = "电梯使用状态")
    private String useStatus;

    // 废弃
    @ApiModelProperty(value = "警情地址")
    private String alertAddress;

    @ApiModelProperty(value = "响应级别")
    private String responseLevel;

    @ApiModelProperty("工单编号")
    private String workOrderNumber;

    @ApiModelProperty(value = "接警时间str")
    private String callTimeStr;

    @ApiModelProperty(value = "冻结原因")
    private String forzenResult;

    @ApiModelProperty(value = "结案说明")
    private String finalReason;

    @ApiModelProperty(value = "是否辅屏查询")
    private String isAuxiliaryScreen;

    @ApiModelProperty(value = "投诉描述/故障报修描述")
    private String describe;
//
//    @ApiModelProperty(value = "图片")
//    private String images;

    @ApiModelProperty(value = "设备id")
    private String equipmentId;

    @ApiModelProperty(value = "现场照片")
    private List<AttachmentDto> images;

    @ApiModelProperty(value = "技能组")
    private String skillGroup;

   private String equipment;
}
