package com.yeejoin.amos.boot.module.elevator.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author system_generator
 * @date 2023-11-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_alert_form_record")
public class AlertFormRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 警情id
     */
    @TableField("alert_called_id")
    private Long alertCalledId;

    /**
     * 警情类型
     */
    @TableField("alert_type_code")
    private String alertTypeCode;

    /**
     * 救援人姓名
     */
    @TableField("name")
    private String name;

    /**
     * 救援人电话
     */
    @TableField("phone")
    private String phone;

    /**
     * 被困人数
     */
    @TableField("trapped_num")
    private Integer trappedNum;

    /**
     * 受伤人数
     */
    @TableField("injured_num")
    private Integer injuredNum;

    /**
     * 死亡人数
     */
    @TableField("die_num")
    private Integer dieNum;

    /**
     * 被困楼层
     */
    @TableField("trapped_floor_num")
    private Integer trappedFloorNum;

    /**
     * 是否有光照
     */
    @TableField("is_light")
    private Integer isLight;

    /**
     * 被困时间
     */
    @TableField("trapped_time")
    private Date trappedTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 事件描述
     */
    @TableField("description")
    private String description;

    /**
     * 故障报修描述
     */
    @TableField("fault_report")
    private String faultReport;

    /**
     * 投诉咨询描述
     */
    @TableField("complaint_consulttation")
    private String complaintConsulttation;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;

}
