package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertDispatchStatisticsDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.AlertDispatchStatistics;
import com.yeejoin.amos.boot.module.elevator.api.mapper.AlertDispatchStatisticsMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IAlertDispatchStatisticsService;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-11-10
 */
@Service
public class AlertDispatchStatisticsServiceImpl extends BaseService<AlertDispatchStatisticsDto, AlertDispatchStatistics, AlertDispatchStatisticsMapper> implements IAlertDispatchStatisticsService {

    @Autowired
    private AlertStatisticsServiceImpl alertStatisticsService;

    @Override
    @Scheduled(cron = "0 0 0 1 * ?")
    @SchedulerLock(name = "AlertDispatchStatisticsServiceImpl", lockAtMostFor = "PT10M", lockAtLeastFor = "PT10M")
    public void statisticalGeneration() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.MONTH, -1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMinimum(Calendar.DAY_OF_MONTH));
        Date firstDayOfMonth = cal.getTime();
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date lastDayOfMonth = cal.getTime();
        List<LinkedHashMap> supervisionList = alertStatisticsService.getSupervisionList();
        List<Map<String, String>> message = this.baseMapper.getMessage(format.format(firstDayOfMonth) + " 00:00:00", format.format(lastDayOfMonth) + " 23:59:59");
        ArrayList<AlertDispatchStatistics> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(supervisionList)) {
            supervisionList.forEach(item -> {
                List<Map<String, String>> collect = message.stream().filter(detail -> detail.get("orgCode").startsWith(String.valueOf(item.get("orgCode")))).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect)) {
                    collect.forEach(data -> {
                        AlertDispatchStatistics alertDispatchStatistics = new AlertDispatchStatistics();
                        BeanUtil.copyProperties(data, alertDispatchStatistics);
                        alertDispatchStatistics.setSupervisoryUnitName(String.valueOf(item.get("companyName")));
                        alertDispatchStatistics.setSupervisoryUnitOrgCode(String.valueOf(item.get("orgCode")));
                        alertDispatchStatistics.setSupervisoryUnitId(String.valueOf(item.get("sequenceNbr")));
                        alertDispatchStatistics.setStartDate(format.format(firstDayOfMonth));
                        alertDispatchStatistics.setEndDate(format.format(lastDayOfMonth));
                        alertDispatchStatistics.setStatisticsDate(format.format(lastDayOfMonth).substring(0, 7));
                        list.add(alertDispatchStatistics);
                    });
                }
            });
            if (!ObjectUtils.isEmpty(list)) {
                this.saveBatch(list);
            }
        }
    }

    @Override
    public List<AlertDispatchStatistics> getList(String date) {
        LambdaQueryWrapper<AlertDispatchStatistics> lambda = new QueryWrapper<AlertDispatchStatistics>().lambda();
        lambda.eq(AlertDispatchStatistics::getStatisticsDate, date);
        return this.baseMapper.selectList(lambda);
    }
}