package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertRescueStatisticsDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.AlertRescueStatistics;
import com.yeejoin.amos.boot.module.elevator.api.mapper.AlertRescueStatisticsMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IAlertRescueStatisticsService;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-11-07
 */
@Service
public class AlertRescueStatisticsServiceImpl extends BaseService<AlertRescueStatisticsDto, AlertRescueStatistics, AlertRescueStatisticsMapper> implements IAlertRescueStatisticsService {


    @Autowired
    private AlertStatisticsServiceImpl alertStatisticsService;

    @Override
    @Scheduled(cron = "0 0 0 1 * ?")
    @SchedulerLock(name = "AlertRescueStatisticsServiceImpl", lockAtMostFor = "PT10M", lockAtLeastFor = "PT10M")
    public void statisticalGeneration() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.MONTH, -1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMinimum(Calendar.DAY_OF_MONTH));
        Date firstDayOfMonth = cal.getTime();
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date lastDayOfMonth = cal.getTime();
        ArrayList<AlertRescueStatistics> list = new ArrayList<>();
        List<LinkedHashMap> supervisionList = alertStatisticsService.getSupervisionList();
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        if (!ObjectUtils.isEmpty(supervisionList)) {
            supervisionList.forEach(item -> {
                AlertRescueStatistics statisticsMessage = this.baseMapper.getStatisticsMessage(String.valueOf(item.get("orgCode")), format.format(firstDayOfMonth) + " 00:00:00", format.format(lastDayOfMonth) + " 23:59:59");
                statisticsMessage.setSupervisoryUnitName(String.valueOf(item.get("companyName")));
                statisticsMessage.setSupervisoryUnitOrgCode(String.valueOf(item.get("orgCode")));
                statisticsMessage.setSupervisoryUnitId(String.valueOf(item.get("sequenceNbr")));
                statisticsMessage.setGreaterNum(statisticsMessage.getMaintenanceUnit() - statisticsMessage.getLessNum());
                if (ObjectUtils.isEmpty(statisticsMessage.getAvgNum()) || ObjectUtils.isEmpty(statisticsMessage.getMaintenanceUnit()) || statisticsMessage.getAvgNum().equals("0") || statisticsMessage.getMaintenanceUnit() == 0) {
                    statisticsMessage.setAvgNum("0");
                } else {
                    BigDecimal bigDecimal = new BigDecimal(statisticsMessage.getAvgNum()).divide(new BigDecimal("60"), 6, BigDecimal.ROUND_HALF_UP);
                    BigDecimal bigDecimal1 = new BigDecimal(statisticsMessage.getMaintenanceUnit().toString());
                    BigDecimal divide = bigDecimal.divide(bigDecimal1, 6, BigDecimal.ROUND_HALF_UP);
                    statisticsMessage.setAvgNum(decimalFormat.format(divide));
                }
                statisticsMessage.setStartDate(format.format(firstDayOfMonth));
                statisticsMessage.setEndDate(format.format(lastDayOfMonth));
                statisticsMessage.setStatisticsDate(format.format(lastDayOfMonth).substring(0, 7));
                list.add(statisticsMessage);
            });
        }
        if (!ObjectUtils.isEmpty(list)) {
            this.saveBatch(list);
        }
    }


    @Override
    public List<AlertRescueStatistics> getList(String date) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        LambdaQueryWrapper<AlertRescueStatistics> lambda = new QueryWrapper<AlertRescueStatistics>().lambda();
        lambda.eq(AlertRescueStatistics::getStatisticsDate, date);
        List<AlertRescueStatistics> alertRescueStatistics = this.baseMapper.selectList(lambda);
        AlertRescueStatistics total = new AlertRescueStatistics();
        total.setSupervisoryUnitName("合计");
        if (!ObjectUtils.isEmpty(alertRescueStatistics)) {
            alertRescueStatistics.forEach(item -> {
                total.setMaintenanceUnit(ObjectUtils.isEmpty(total.getMaintenanceUnit()) ? item.getMaintenanceUnit() : total.getMaintenanceUnit() + item.getMaintenanceUnit());
                total.setLessNum(ObjectUtils.isEmpty(total.getLessNum()) ? item.getLessNum() : total.getLessNum() + item.getLessNum());
                total.setGreaterNum(ObjectUtils.isEmpty(total.getGreaterNum()) ? item.getGreaterNum() : total.getGreaterNum() + item.getGreaterNum());
                total.setLevelOne(ObjectUtils.isEmpty(total.getLevelOne()) ? item.getLevelOne() : total.getLevelOne() + item.getLevelOne());
                total.setLevelTwo(ObjectUtils.isEmpty(total.getLevelTwo()) ? item.getLevelTwo() : total.getLevelTwo() + item.getLevelTwo());
                total.setLevelThree(ObjectUtils.isEmpty(total.getLevelThree()) ? item.getLevelThree() : total.getLevelThree() + item.getLevelThree());
                total.setAvgNum(ObjectUtils.isEmpty(total.getAvgNum()) ? item.getAvgNum() : String.valueOf(Double.parseDouble(total.getAvgNum()) + Double.parseDouble(item.getAvgNum())));
            });
            if (ObjectUtils.isEmpty(total.getAvgNum()) || total.getAvgNum().equals("0")) {
                total.setAvgNum("0");
            } else {
                BigDecimal bigDecimal = new BigDecimal(total.getAvgNum());
                BigDecimal bigDecimal1 = new BigDecimal(alertRescueStatistics.size());
                BigDecimal divide = bigDecimal.divide(bigDecimal1, 6, BigDecimal.ROUND_HALF_UP);
                total.setAvgNum(decimalFormat.format(divide));
            }
            alertRescueStatistics.add(total);
        }
        return alertRescueStatistics;
    }
}