package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertUseUnitStatisticsDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.AlertUseUnitStatistics;
import com.yeejoin.amos.boot.module.elevator.api.mapper.AlertUseUnitStatisticsMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IAlertUseUnitStatisticsService;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-11-08
 */
@Service
public class AlertUseUnitStatisticsServiceImpl extends BaseService<AlertUseUnitStatisticsDto, AlertUseUnitStatistics, AlertUseUnitStatisticsMapper> implements IAlertUseUnitStatisticsService {


    @Override
    @Scheduled(cron = "0 0 0 1 * ?")
    @SchedulerLock(name = "AlertUseUnitStatisticsServiceImpl", lockAtMostFor = "PT10M", lockAtLeastFor = "PT10M")
    public void statisticalGeneration() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.MONTH, -1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMinimum(Calendar.DAY_OF_MONTH));
        Date firstDayOfMonth = cal.getTime();
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date lastDayOfMonth = cal.getTime();
        ArrayList<AlertUseUnitStatistics> list = new ArrayList<>();
        List<Map<String, String>> statisticsMessage = this.baseMapper.getStatisticsMessage(format.format(firstDayOfMonth) + " 00:00:00", format.format(lastDayOfMonth) + " 23:59:59");
        if (!ObjectUtils.isEmpty(statisticsMessage)){
            statisticsMessage.forEach(item -> {
                if (!ObjectUtils.isEmpty(item.get("equipmentId")) && !ObjectUtils.isEmpty(item.get("unitCode"))){
                    AlertUseUnitStatistics useUnitMessage = this.baseMapper.getUseUnitMessage(item.get("unitCode"), item.get("equipmentId"), format.format(firstDayOfMonth) + " 00:00:00", format.format(lastDayOfMonth) + " 23:59:59");
                    BeanUtil.copyProperties(item, useUnitMessage);
                    useUnitMessage.setStartDate(format.format(firstDayOfMonth));
                    useUnitMessage.setEndDate(format.format(lastDayOfMonth));
                    useUnitMessage.setStatisticsDate(format.format(lastDayOfMonth).substring(0, 7));
                    list.add(useUnitMessage);
                }
            });
            this.saveBatch(list);
        }
    }

    @Override
    public List<AlertUseUnitStatistics> getList(String date) {
        LambdaQueryWrapper<AlertUseUnitStatistics> lambda = new QueryWrapper<AlertUseUnitStatistics>().lambda();
        lambda.eq(AlertUseUnitStatistics :: getStatisticsDate, date);
        return this.baseMapper.selectList(lambda);
    }
}