package com.yeejoin.amos.patrol.business.dao.repository;

import com.yeejoin.amos.patrol.dao.entity.PlanTaskDetail;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
@Repository("planTaskDetail")
@EnableJpaRepositories
public interface IPlanTaskDetailDao extends BaseDao<PlanTaskDetail, Long> {

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_plan_task_detail WHERE point_id IN (?1)", nativeQuery = true)
	void deletePlanTaskDetailByPointId(List<Long> pointIds);

	/**
	 * 根据任务id获取任务详情
	 * @param planTaskId
	 * @return
	 */
	public List<PlanTaskDetail> findAllByTaskNo(Long planTaskId);

	/**
	 * 根据任务id及状态获取计划详情
	 * @param planTaskId
	 * @return
	 */
	public List<PlanTaskDetail> findAllByTaskNoAndStatus(Long planTaskId,String status);


	int countByIsFinish(int status);

	int countByIsFinishAndTaskNo(int status,Long taskNo);

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_plan_task_detail WHERE task_no IN (?1)", nativeQuery = true)
	void deletePlanTaskDetailByTaskNo(List<Long> planTaskNo);

	@Query(value = "select * FROM p_plan_task_detail WHERE point_id IN (?1)", nativeQuery = true)
    List<PlanTaskDetail> findALLByPointId(Long pointId);

	@Query(value = "select * FROM p_plan_task_detail WHERE id = ?1 AND status = ?2", nativeQuery = true)
	List<PlanTaskDetail> findAllByIdAndStatus(long id, String status);
}
