package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 安全追溯-电梯
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("3000")
public class ElevatorTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "ratedSpeedUp", label = "额定速度(上行)", equCategory = {"3200", "3400"}, equDefine = {"3210", "3220", "3410", "3420"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/s")
    private BigDecimal ratedSpeedUp;


    @TechnicalParameter(key = "ratedSpeedDown", label = "额定速度(下行)", equCategory = {"3200", "3400"}, equDefine = {"3210", "3220", "3410", "3420"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/s")
    private BigDecimal ratedSpeedDown;


    @TechnicalParameter(key = "ratedLoadCapacity", label = "额定载重量", equCategory = {"3100", "3200", "3400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "kg")
    private BigDecimal ratedLoadCapacity;


    @TechnicalParameter(key = "liftingHeight", label = "提升高度", equCategory = {"3300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal liftingHeight;


    @TechnicalParameter(key = "storey", label = "层数", equCategory = {"3100", "3200", "3400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "层")
    private BigDecimal storey;


    @TechnicalParameter(key = "stand", label = "站数", equCategory = {"3100", "3200", "3400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "站")
    private BigDecimal stand;


    @TechnicalParameter(key = "numberDoors", label = "门数", equCategory = {"3100", "3200", "3400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "门数")
    private BigDecimal numberDoors;


    @TechnicalParameter(key = "controlMode", label = "控制方式", equCategory = {"3100", "3200", "3400"}, type = TechnicalParameter.ParamType.STRING, dictCode = "KZFS")
    private String controlMode;


    @TechnicalParameter(key = "numberCylinders", label = "油缸数量", equCategory = {"3200", "3400"}, equDefine = {"3210", "3220", "3420"}, type = TechnicalParameter.ParamType.BIG_DECIMAL)
    private BigDecimal numberCylinders;


    @TechnicalParameter(key = "jackingType", label = "顶升方式", equCategory = {"3200", "3400"}, equDefine = {"3210", "3220", "3420"}, type = TechnicalParameter.ParamType.STRING, dictCode = "DSXS")
    private String jackingType;


    @TechnicalParameter(key = "explosionproofGrade", label = "区域防爆等级", equCategory = {"3400"}, equDefine = {"3410"}, type = TechnicalParameter.ParamType.STRING, dictCode = "FBDJ")
    private String explosionproofGrade;

//    附件上传类型的参数，无法参与查询，暂时注释掉
//    @TechnicalParameter(key = "explosionproofSignComplete", label = "整机防爆标志", equCategory = {"3400"}, equDefine = {"3410"}, type = TechnicalParameter.ParamType.STRING)
//    private String explosionproofSignComplete;


    @TechnicalParameter(key = "nominalSpeed", label = "名义速度", equCategory = {"3300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/s")
    private BigDecimal nominalSpeed;


    @TechnicalParameter(key = "nominalWidth", label = "名义宽度", equCategory = {"3300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal nominalWidth;

    @TechnicalParameter(key = "angleRoll", label = "倾斜角", equCategory = {"3100", "3300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL)
    private BigDecimal angleRoll;


    @TechnicalParameter(key = "useSectionLength", label = "使用区段长度", equCategory = {"3300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal useSectionLength;


    @TechnicalParameter(key = "conveyingCapacity", label = "输送能力", equCategory = {"3300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "P/h")
    private BigDecimal conveyingCapacity;


    @TechnicalParameter(key = "doorPosition", label = "轿门位置", equCategory = {"3100"}, type = TechnicalParameter.ParamType.STRING)
    private String doorPosition;


    @TechnicalParameter(key = "ratedSpeed", label = "额定速度", equCategory = {"3100", "3400"}, equDefine = {"3110", "3120", "3130", "3430"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/s")
    private BigDecimal ratedSpeed;
}
