package com.yeejoin.amos.boot.module.statistics.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 问题状态
 */

public enum ProblemStatusEnum {
    NORMAL("正常", "0"),
    ABNORMAL("异常", "1");

    private String name;

    private String code;

    ProblemStatusEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setStatus(String code) {
        this.code = code;
    }

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();

    static {
        for (ProblemStatusEnum e : ProblemStatusEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }
}

