
package com.yeejoin.amos.fas.business.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.google.common.base.Joiner;
import com.yeejoin.amos.fas.business.dao.mapper.RiskLevelMapper;
import com.yeejoin.amos.fas.business.dao.repository.IRiskLevelDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskSourceDao;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IRiskLevelService;
import com.yeejoin.amos.fas.business.util.StringUtil;
import com.yeejoin.amos.fas.common.enums.ManageLevelEum;
import com.yeejoin.amos.fas.dao.entity.RiskLevel;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import com.yeejoin.amos.fas.exception.YeeException;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
@Service("riskLevelService")
public class RiskLevelServiceImpl implements IRiskLevelService {
	@Autowired 
	RiskLevelMapper riskLevelMapper;
	@Autowired
	IRiskLevelDao  iRiskLevelDao;
	@Autowired
	IRiskSourceDao iRiskSourceDao;
	@Autowired
	private RemoteSecurityService remoteSecurityService;
	
	@Override
	public Page<HashMap<String, Object>> queryRiskLevelPage(String toke,String product,String appKey,CommonPageInfoParam param) {
		long total = riskLevelMapper.countPageData(param);
		List<HashMap<String, Object>> content = riskLevelMapper.queryRiskLevelPage(param);
		if(!CollectionUtils.isEmpty(content)){
			Set<String> userIds = new HashSet<String>();
			for(HashMap<String, Object> map : content)
			{
				String userId = String.valueOf(map.get("createBy"));
				userIds.add(userId);
			}
			userIds.remove(null);
			userIds.remove("");
			List<AgencyUserModel> users = new ArrayList<>();
			if(!CollectionUtils.isEmpty(userIds)){
				users = remoteSecurityService.listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
			}
			Map<String, String> userMap = users.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName));
			content.forEach(e -> {
				e.put("userName", userMap.get(String.valueOf(e.get("createBy"))));
				e.put("manageLevelName",
						StringUtil.isNotEmpty(e.get("manageLevel")) ? ManageLevelEum.getNameByManageLevel(Integer.parseInt(e.get("manageLevel").toString())) : "");
			});
		}
		return new PageImpl<>(content, param, total);

	}


	@Override
	public void editRiskLevel(HashMap<String, Object>  map) {
		RiskLevel param =  (RiskLevel) map.get("param");
		String orgCode = map.get("org_code") == null ? "":map.get("org_code").toString();
		String userId = map.get("user_id")== null ? "0":map.get("user_id").toString();
		param.setOrgCode(orgCode);
		param.setCreateBy(userId);
		param.setCreateDate(new Date());
		iRiskLevelDao.save(param);
	}

	@Override
	public void detRiskLevel(Long[] param) {
		//1.校验
		for(Long id : param){
			checkBeforeDet(id);
		}
		//2.删除
		iRiskLevelDao.deleteAllByIds(param);
	}

	/**
	 * 删除前校验
	 * @param id
	 */
	private void checkBeforeDet(Long id) {
		List<RiskSource> list = iRiskSourceDao.findByRiskLevelId(id);
		if(null !=list && list.size() >0){
			throw new YeeException("风险点"+list.get(0).getName()+"在使用中，不能删除");
		}
	}

	@Override
	public List<RiskLevel> queryRiskLevel(Long id) {
		List<RiskLevel> list = new ArrayList<RiskLevel>();
		if(null == id){
			list = iRiskLevelDao.findAll();
		}else{
			list = iRiskLevelDao.findByEvaluationModelId(id);
		}
		return list;
	}

	@Override
	public Long countRepeatData(RiskLevel param) {
		// TODO Auto-generated method stub
		
		return riskLevelMapper.countRepeatData(param);
	}

}

