package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.TemplateDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.TemplateExtendDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Template;
import com.yeejoin.amos.boot.module.jcs.api.mapper.TemplateMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.ITemplateService;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
* 模板表 服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class TemplateServiceImpl extends BaseService<TemplateDto,Template,TemplateMapper> implements ITemplateService {

    @Override
    public Template getByTypeAndFormat(String type, String format) {
        return this.baseMapper.selectOne(new QueryWrapper<Template>().eq("type_code", type).eq("format", format));
    }

    @Override
    public TemplateExtendDto getByType(String typeCode) {
        TemplateExtendDto templateExtendDto = new TemplateExtendDto();
        List<TemplateDto> templateDtoList =  this.queryForList(null, false, typeCode);
        templateDtoList.forEach(templateDto -> {
            if (templateDto.getFormat()) {
                templateExtendDto.setRichContent(templateDto.getContent());
            } else {
                templateExtendDto.setContent(templateDto.getContent());
            }
        });
        return templateExtendDto;
    }
}
