package com.yeejoin.amos.maintenance.business.feign;

import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */ //装备
@FeignClient(name = "${equip.feign.name}")
public interface EquipFeignClient {
    String PREFIX = "${equip.feign.prefix}";

    @RequestMapping(value = PREFIX + "/equipSpecific/getSourceNameByEquipSpeId", method = RequestMethod.GET, consumes = "application/json")
    LinkedHashMap<String, Object> getEquipDetail(@RequestParam(value = "id") Long id);

    @RequestMapping(value = PREFIX + "/equipSpecific/getSourceNameList", method = RequestMethod.POST, consumes = "application/json")
    LinkedHashMap<String, Object> getEquipList(@RequestBody Long id);

    @RequestMapping(value = PREFIX + "/warehouse-structure/listAll", method = RequestMethod.GET, consumes = "application/json")
    String getStructureNameAll();

    /**
     * 消防建筑树
     *
     * @return
     */
    @RequestMapping(value = PREFIX + "/building/tree", method = RequestMethod.GET, consumes = "application/json")
    LinkedHashMap<String, Object> getBuildingTree();

    @RequestMapping(value = PREFIX + "/building/getBuildingAbsolutePosition", method = RequestMethod.GET, consumes = "application/json")
    LinkedHashMap<String, Object> getBuildingAbsolutePosition();

    /**
     * 所属局域树
     *
     * @return
     */
    @RequestMapping(value = PREFIX + "/area/tree", method = RequestMethod.GET, consumes = "application/json")
    LinkedHashMap<String, Object> getRegionTress();

    /**
     * 查询维保到期设备
     *
     * @param type
     * @param id
     * @return
     */
    @GetMapping(value = PREFIX+"/maintenanceResourceData/getFireFacilityList")
    ResponseModel<List<Map<String, Object>>> overTimeMaintenanceFacility(@RequestParam String type, @RequestParam String id);
}

