package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 动态表单树形分组字段表
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DynamicFormColumnDto", description = "动态表单树形分组字段表")
public class DynamicFormColumnDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "字段名")
    private String fieldCode;

    @ApiModelProperty(value = "中文名")
    private String fieldName;

    @ApiModelProperty(value = "字段类型(web使用）")
    private String fieldType;

    @ApiModelProperty(value = "字段分组主键")
    private Long groupId;

    @ApiModelProperty(value = "查询策略;全等,模糊,区间")
    private String queryStrategy;

    @ApiModelProperty(value = "不能为空")
    private Boolean notNull;

    @ApiModelProperty(value = "是否一行显示(兼容已有动态表单使用)")
    private Boolean block;

    @ApiModelProperty(value = "所属分组编号")
    private String groupCode;

    @ApiModelProperty(value = "配置json")
    private JSONObject columnConfig;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ApiModelProperty(value = "提示信息")
    private String remark;

    @ApiModelProperty(value = "排序字段")
    private int sort;

    @ApiModelProperty(value = "组织机构")
    private String orgCode;

}
