package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.List;

/**
 * @Author cpp
 * @Description
 * @Date 2023/6/5
 */
@Data
@Accessors(chain = true)
@Document(indexName = "web_app_task_detail", shards = 6, replicas = 2)
public class ESTaskDetailDto {


    @Id
    private String id;

    @Field(type = FieldType.Text)
    private String pointId;

    @Field(type = FieldType.Text)
    private String planTaskId;

    @Field(type = FieldType.Text)
    private String pointName;

    @Field(type = FieldType.Text)
    private String pointNo;

    @Field(type = FieldType.Text)
    private String shortMinNumber;

    @Field(type = FieldType.Text)
    private String shortMaxNumber;



    @Field(type = FieldType.Text)
    private String checkTime;

    @Field(type = FieldType.Text)
    private String beginTime;

    @Field(type = FieldType.Text)
    private String endTime;

    @Field(type = FieldType.Text)
    private String pointStatus;

    @Field(type = FieldType.Text)
    private String planName;

    @Field(type = FieldType.Text)
    private String taskStatus;

    @Field(type = FieldType.Text)
    private String departmentName;

    @Field(type = FieldType.Text)
    private String username;



    @Field(type = FieldType.Text)
    private String strCheckTime;

    @Field(type = FieldType.Text)
    private String checkId;

    @Field(type = FieldType.Text)
    private String remark;

    @Field(type = FieldType.Text)
    private String score;

    private String isRisk;


    @Field(type = FieldType.Text)
    private List<String> pointImgUrls;

    @Field(type = FieldType.Object)
    private JSONObject appCheckInput;


}
