package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ZBGLDPStatisticsServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertPaperInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author maxy
 */
@RestController
@Api(tags = "大屏-指标-统计API")
@RequestMapping("/dp/zb")
public class ZBGLDPStatisticsController {
    @Autowired
    private ZBGLDPStatisticsServiceImpl statisticsService;
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-指标管理下钻左侧树结构", notes = "大屏-指标管理下钻左侧树结构")
    @PostMapping(value = "/getType")
    public ResponseModel<List<Map<String, Object>>> getType(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getType(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-指标管理下钻图表", notes = "大屏-指标管理下钻图表")
    @PostMapping(value = "/getChart")
    public ResponseModel<Map<String, Object>> getChart(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getChart(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-指标管理下钻表头", notes = "大屏-指标管理下钻表头")
    @PostMapping(value = "/getTitle")
    public ResponseModel<List<Map<String, String>>> getTitle(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getTitle(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-指标管理下钻分页", notes = "大屏-指标管理下钻分页")
    @PostMapping(value = "/getPage")
    public ResponseModel<Page<Map<String, Object>>> getPage(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result,
                                                            @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                            @RequestParam(value = "size", defaultValue = "20") Integer size) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(statisticsService.getPage(page,dpFilterParamForDetailDto));
    }
}
