package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.MidMaintenanceInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.MidMaintenanceInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidMaintenanceInfo;
import com.yeejoin.amos.api.openapi.feign.TzsServiceFeignClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-维保备案信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class MaintenanceInfoService extends AppBaseService<MidMaintenanceInfoModel, MidMaintenanceInfo, MidMaintenanceInfoMapper> {

	private static final Logger logger = LogManager.getLogger(ConstructionInfoService.class);

	@Autowired
	TzsServiceFeignClient tzsServiceFeignClient;

	@Autowired
	private JgFileService fileService;

	/**
	 * 新增维保备案信息
	 *
	 * @param maintenanceInfo 维保备案信息
	 * @return 成功返回“OK”
	 */
	@Transactional(rollbackFor = {Exception.class})
	public String saveMaintenanceInfo(MidMaintenanceInfo maintenanceInfo) {
		try {
			tzsServiceFeignClient.saveMaintenanceRecordInfo(maintenanceInfo);
		} catch (Exception e) {
            logger.error("维保备案信息保存失败--->{}", e.getMessage());
            e.printStackTrace();
		}
		return "OK";
	}

	/**
	 * 新增维保备案信息
	 *
	 * @param model 维保备案信息实体类集合
	 * @return 成功返回“OK”
	 */
	@Transactional(rollbackFor = {Exception.class})
	public String saveMaintenanceInfo(List<MidMaintenanceInfoModel> model) {
		// TODO Auto-generated method stub
		if (ValidationUtil.isEmpty(model)) {
			throw new BadRequest("维保备案信息为空.");
		}

		List<MidMaintenanceInfo> mainList = new ArrayList<>();
//        List<JgFile> fileList = new ArrayList<>();
//        List<JgFile> repairInformList;

		for (MidMaintenanceInfoModel models : model) {
			MidMaintenanceInfo maintenanceInfo = new MidMaintenanceInfo();
//            checkModel(models);
			models.setRecDate(new Date());
			models.setAppId(getAppId());

//            repairInformList = JSONObject.parseArray(JSONObject.toJSONString(models.getRepairInform()), JgFile.class);
//
//            for (JgFile files : repairInformList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.MAINTENANCE_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.REPAIR_INFORM.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                fileList.add(file);
//            }
			BeanUtils.copyProperties(models, maintenanceInfo);
			mainList.add(maintenanceInfo);
		}
		this.saveBatch(mainList);
//        fileService.saveBatch(fileList);
		return "OK";
	}

	/**
	 * 信息校验
	 *
	 * @param models
	 */
//    private static void checkModel(MaintenanceInfoModel models) {
//        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
//            throw new BadRequest("设备唯一标识码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getMeUnitCreditCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"维保单位统一社会信用代码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getMeUnitName())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"维保单位名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getRepairInformId())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"维保合同备案ID不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getInformStart())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"维保合同开始日期不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getInformEnd())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"维保合同结束日期不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getMeMaster())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"维保负责人姓名不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEmergencycall())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"紧急救援电话不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getMeCycle())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"维保周期(单位：月)不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getMe24Telephone())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"24小时维保电话不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
//        }
//    }
}
