package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jg.biz.core.BaseService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgMaintenanceRecordInfoService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgMaintenanceRecordInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgMaintenanceRecordInfoMapper;
import org.springframework.stereotype.Service;

/**
 * 安全追溯-维保备案信息表服务实现类
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Service
public class IdxBizJgMaintenanceRecordInfoServiceImpl extends BaseService<IdxBizJgMaintenanceRecordInfoMapper, IdxBizJgMaintenanceRecordInfo> implements IIdxBizJgMaintenanceRecordInfoService {

    public boolean saveOrUpdateData(IdxBizJgMaintenanceRecordInfo maintenanceRecordInfo) {
        return super.saveOrUpdateWithNull(maintenanceRecordInfo);
    }

    /**
     * 查询最新的维保记录
     */
    @Override
    public IdxBizJgMaintenanceRecordInfo queryNewestDetailByRecord(String record) {
        QueryWrapper<IdxBizJgMaintenanceRecordInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(IdxBizJgMaintenanceRecordInfo::getRecord, record).orderByDesc(IdxBizJgMaintenanceRecordInfo::getRecDate).last("limit 1");
        IdxBizJgMaintenanceRecordInfo init = new IdxBizJgMaintenanceRecordInfo();
        IdxBizJgMaintenanceRecordInfo last = getOne(queryWrapper);
        if (last != null) {
            init = last;
        }
        return init;
    }


}