package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 游乐设施
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_recreation_facility")
public class SpecialRecreationFacility extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 设备全省唯一编号
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 游乐设施线速度(m/s)
	 */
	@TableField("recreation_facility_linear_velocity")
	private String recreationFacilityLinearVelocity;
	/**
	 * 游乐设施高度(m)
	 */
	@TableField("recreation_facility_height")
	private String recreationFacilityHeight;
	/**
	 * 额定乘客人数(人)
	 */
	@TableField("rate_passenger_num")
	private String ratePassengerNum;
	/**
	 * 额定载荷(kg)
	 */
	@TableField("rated_load")
	private String ratedLoad;
	/**
	 * 额定速度(m/s)
	 */
	@TableField("rated_speed")
	private String ratedSpeed;
	/**
	 * 倾夹角或坡度(°)
	 */
	@TableField("inclination_slope")
	private String inclinationSlope;
	/**
	 * 副速度(m/s)
	 */
	@TableField("sec_speed")
	private String secSpeed;
	/**
	 * 驱动形式
	 */
	@TableField("drive_model")
	private String driveModel;
	/**
	 * 驱动主功率(kW)
	 */
	@TableField("drive_main_power")
	private String driveMainPower;
	/**
	 * 电压(V)
	 */
	@TableField("voltage")
	private String voltage;
	/**
	 * 副功率(kW)
	 */
	@TableField("sec_power")
	private String secPower;
	/**
	 * 座舱高度(m)
	 */
	@TableField("cockpit_height")
	private String cockpitHeight;
	/**
	 * 回转直径(mm)
	 */
	@TableField("rotary_diameter")
	private String rotaryDiameter;
	/**
	 * 轨矩(m)
	 */
	@TableField("rail_moment")
	private String railMoment;
	/**
	 * 轨矩长度(mm)
	 */
	@TableField("rail_moment_length")
	private String railMomentLength;
	/**
	 * 水滑梯高度(m)
	 */
	@TableField("water_slide_heigth")
	private String waterSlideHeigth;
	/**
	 * 游乐池水深(m)
	 */
	@TableField("recreation_pool_depth")
	private String recreationPoolDepth;
	/**
	 * 设计使用寿命
	 */
	@TableField("design_use_life")
	private String designUseLife;
	/**
	 * 高度（静态）(m)
	 */
	@TableField("static_heigth")
	private String staticHeigth;

}
