package com.yeejoin.amos.boot.module.jcs.api.feign;

import org.springframework.http.HttpStatus;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

public class CommonResponseUtil2 {
    public static ResponseModel<Object> success() {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setDevMessage(Constant.RESULT_SUCCESS);
        res.setStatus(HttpStatus.OK.value());
        return res;
    }

    public static ResponseModel<Object> success(Object obj) {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setResult(obj);
        res.setDevMessage(Constant.RESULT_SUCCESS);
        res.setStatus(HttpStatus.OK.value());
        return res;
    }

    public static ResponseModel<Object> success(Object obj, String message) {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setResult(obj);
        res.setDevMessage(message);
        res.setStatus(HttpStatus.OK.value());
        return res;
    }

    public static ResponseModel<Object> failure() {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setDevMessage(Constant.RESULT_FAILURE);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return res;
    }

    public static ResponseModel<Object> failure(String message) {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setDevMessage(Constant.RESULT_FAILURE);
        res.setMessage(message);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return res;
    }

    public static ResponseModel<Object> failure(Object obj, String message) {
        ResponseModel<Object> res = new ResponseModel<Object>();
        res.setResult(obj);
        res.setMessage(message);
        res.setDevMessage(Constant.RESULT_FAILURE);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return res;
    }

    private CommonResponseUtil2() {
    }
}
