package com.yeejoin.precontrol.common.utils;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.*;
import com.yeejoin.precontrol.common.enums.TaskPersonTypeEnum;
import com.yeejoin.precontrol.common.enums.TaskTypeEnum;
import com.yeejoin.precontrol.common.mapper.PersonMapper;
import com.yeejoin.precontrol.common.service.*;
import com.yeejoin.precontrol.common.vo.PersonVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class PersonUtils {

	@Autowired
	IProjectService iProjectService;

	@Autowired
	IProjectScoreService iProjectScoreService;

	@Autowired
	IPersonAscriptionService iPersonAscriptionService;

	@Autowired
	ICompanyService iCompanyService;

	@Autowired
	ITaskService iTaskService;

	@Autowired
	IPersonService iPersonService;

	@Autowired
	IPersonMessageService iPersonMessageService;

	@Autowired
	PersonUtils personUtils;

	@Autowired
	PersonMapper personMapper;

	@Autowired
	ITaskPersonService iTaskPersonService;

	/**
	 * 查询分包商 安全员
	 *
	 * @return
	 */
	public List<Long> getFbsSecurityPerson(Long companyId) {
		List<PersonAscription> list = iPersonAscriptionService
				.list(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getCompanyId, companyId));
		if (StringUtil.isNotEmpty(list)) {
			List<Long> userIds = list.stream().map(m -> m.getPersonId()).collect(Collectors.toList());
			List<Person> fbsSecurity = iPersonService.list(
					new LambdaQueryWrapper<Person>().in(Person::getId, userIds).eq(Person::getRoleKey, "fbs_security"));
			if (StringUtil.isNotEmpty(fbsSecurity)) {
				return fbsSecurity.stream().map(m -> m.getId()).collect(Collectors.toList());
			}
		}
		return new ArrayList<>();
	}

	/**
	 * 查询项目部 安全员
	 *
	 * @return
	 */
	public List<Long> getProjectSecurityPerson(Long projectId) {
		Project project = iProjectService.getById(projectId);
		if(project==null) 
		{
			return new ArrayList<>();
		}
		List<Person> fbsSecurity = iPersonService
				.list(new LambdaQueryWrapper<Person>().eq(Person::getRoleKey, "security")
						.eq(Person::getDeptType, "project").like(Person::getOrgCode, project.getOrgCode()));
		if (StringUtil.isNotEmpty(fbsSecurity)) {
			return fbsSecurity.stream().map(m -> m.getId()).collect(Collectors.toList());
		}
		return new ArrayList<>();
	}

	/**
	 * 查询项目部 技术员
	 *
	 * @return
	 */
	public List<Long> getProjectTechPerson(Long projectId) {
		Project project = iProjectService.getById(projectId);
		if(project==null) 
		{
			return new ArrayList<>();
		}
		List<Person> fbsSecurity = iPersonService
				.list(new LambdaQueryWrapper<Person>().eq(Person::getRoleKey, "technician")
						.eq(Person::getDeptType, "project").like(Person::getOrgCode, project.getOrgCode()));
		if (StringUtil.isNotEmpty(fbsSecurity)) {
			return fbsSecurity.stream().map(m -> m.getId()).collect(Collectors.toList());
		}
		return new ArrayList<>();
	}

	/**
	 * 查询项目部 技术员
	 *
	 * @return
	 */
	public List<Long> getProjectDirectorPerson(Long projectId) {
		Project project = iProjectService.getById(projectId);
		if(project==null) 
		{
			return new ArrayList<>();
		}
		List<Person> fbsSecurity = iPersonService
				.list(new LambdaQueryWrapper<Person>().eq(Person::getRoleKey, "director")
						.eq(Person::getDeptType, "project").like(Person::getOrgCode, project.getOrgCode()));
		if (StringUtil.isNotEmpty(fbsSecurity)) {
			return fbsSecurity.stream().map(m -> m.getId()).collect(Collectors.toList());
		}
		return new ArrayList<>();
	}

	/**
	 * 查询总部人资
	 *
	 * @return
	 */
	public List<Long> getPlatformHRPerson() {
		List<PersonAscription> list = iPersonAscriptionService.list();
		if (StringUtil.isNotEmpty(list)) {
			List<Long> userIds = list.stream().map(m -> m.getPersonId()).collect(Collectors.toList());
			List<Person> security = iPersonService.list(new LambdaQueryWrapper<Person>().in(Person::getId, userIds)
					.eq(Person::getRoleKey, "hr").eq(Person::getIsJxdj, 1L).eq(Person::getDeptType, "public"));
			if (StringUtil.isNotEmpty(security)) {
				return security.stream().map(m -> m.getId()).collect(Collectors.toList());
			}
		}
		return new ArrayList<>();
	}

	/**
	 * 查询总部 安全员
	 *
	 * @return
	 */
	public List<Long> getPlatformSecurityPerson() {
		List<PersonAscription> list = iPersonAscriptionService.list();
		if (StringUtil.isNotEmpty(list)) {
			List<Long> userIds = list.stream().map(m -> m.getPersonId()).collect(Collectors.toList());
			List<Person> security = iPersonService.list(new LambdaQueryWrapper<Person>().in(Person::getId, userIds)
					.eq(Person::getRoleKey, "security").eq(Person::getIsJxdj, 1L).eq(Person::getDeptType, "public"));
			if (StringUtil.isNotEmpty(security)) {
				return security.stream().map(m -> m.getId()).collect(Collectors.toList());
			}
		}
		return new ArrayList<>();
	}

	/**
	 * 查询总部 安全员
	 *
	 * @return
	 */
	public List<Long> getPlatformTechPerson() {
		List<PersonAscription> list = iPersonAscriptionService.list();
		if (StringUtil.isNotEmpty(list)) {
			List<Long> userIds = list.stream().map(m -> m.getPersonId()).collect(Collectors.toList());
			List<Person> security = iPersonService.list(new LambdaQueryWrapper<Person>().in(Person::getId, userIds)
					.eq(Person::getRoleKey, "technician").eq(Person::getIsJxdj, 1L).eq(Person::getDeptType, "public"));
			if (StringUtil.isNotEmpty(security)) {
				return security.stream().map(m -> m.getId()).collect(Collectors.toList());
			}
		}
		return new ArrayList<>();
	}

	/**
	 * 
	 * 
	 * @param projectId
	 * @return
	 */
	public Set<Long> getDefaultPerson(Long projectId) {
		Set<Long> set = new HashSet<>();
		set.addAll(getProjectSecurityPerson(projectId));
		set.addAll(getProjectTechPerson(projectId));
		set.addAll(getProjectDirectorPerson(projectId));
		set.addAll(getPlatformSecurityPerson());
		return set;
	}

	/**
	 * 所属项目部安全员、技术员、主管；总部安全员
	 * 
	 * @param taskId
	 * @return
	 */
	public Set<Long> getWXTaskBasicPerson(Long taskId) {
		Set<Long> set = new HashSet<>();
		Task task = iTaskService.getById(taskId);
		Long projectId = task.getProjectId();
		List<Long> ids = new ArrayList<Long>();
		// 任务分包商执行人
		if (TaskTypeEnum.KNOWLEDGE_SHARE.getValue().equals(task.getType())) {
			ids.add(TaskPersonTypeEnum.STUDY.getValue());
		} else if (TaskTypeEnum.JOBDISCLOSURE.getValue().equals(task.getType())) {
			ids.add(TaskPersonTypeEnum.HOSTPERSON.getValue());
			ids.add(TaskPersonTypeEnum.CONSTRUCTIONDIRECTOR.getValue());
			ids.add(TaskPersonTypeEnum.SAFETYOFFICER.getValue());
			ids.add(TaskPersonTypeEnum.NOTETAKER.getValue());
			ids.add(TaskPersonTypeEnum.PARTICIPATEDISCLOSURE.getValue());
			set.addAll(getPlatformTechPerson());
		} else if (TaskTypeEnum.TASKPAYCHECK.getValue().equals(task.getType())) {
			ids.add(TaskPersonTypeEnum.TECHNICIAN.getValue());
			ids.add(TaskPersonTypeEnum.ENGINEERINGSTAFF.getValue());
			ids.add(TaskPersonTypeEnum.BUILDER.getValue());
			ids.add(TaskPersonTypeEnum.SAFETYOFFICER.getValue());
			ids.add(TaskPersonTypeEnum.PLATFORMSAFETYOFFICER.getValue());
			set.addAll(getPlatformSecurityPerson());
		} else if (TaskTypeEnum.SALARY_CONFIRM.getValue().equals(task.getType())) {
			ids.add(TaskPersonTypeEnum.SALARYCONFIRM.getValue());
			set.addAll(getPlatformHRPerson());
		}
		List<TaskPerson> taskpersons = new ArrayList<>();
		if (!StringUtil.isEmpty(ids)) {
			taskpersons = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getTaskId, taskId)
					.in(TaskPerson::getType, ids));
		}
		List<Long> taskPersonIds = taskpersons.stream().map(TaskPerson::getPersonId).collect(Collectors.toList());
		// 任务分包商主管
		Set<Long> companyIds = taskpersons.stream().map(TaskPerson::getCompanyId).collect(Collectors.toSet());
		List<PersonVo> dirctorList = new ArrayList<>();
		if(!StringUtil.isEmpty(companyIds)) 
		{
			dirctorList = personMapper.listByCompanyAndRole(new ArrayList<Long>(companyIds), "fbs_director");
		}
		Set<Long> directIds = dirctorList.stream().map(PersonVo::getId).collect(Collectors.toSet());
		set.addAll(directIds);
		set.addAll(taskPersonIds);
		set.addAll(personUtils.getProjectDirectorPerson(projectId));
		set.addAll(personUtils.getProjectSecurityPerson(projectId));
		set.addAll(personUtils.getProjectTechPerson(projectId));
		return set;
	}
}
