package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.ManufacturerInfo;
import com.yeejoin.equipmanage.common.entity.SystemDic;
import com.yeejoin.equipmanage.common.enums.SystemDicTypeEum;
import com.yeejoin.equipmanage.common.response.ManufactBasicDataResponse;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.IManufacturerInfoService;
import com.yeejoin.equipmanage.service.ISystemDicService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "生产厂商信息Api")
@RequestMapping(value = "/manufacturer-info", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ManufacturerInfoController {

	@Autowired
	IManufacturerInfoService iManufacturerInfoService;

	@Autowired
	ISystemDicService iSystemDicService;

	/**
	 * 新增
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ManufacturerInfo saveManufacturerInfo(HttpServletRequest request,
			@RequestBody ManufacturerInfo manufacturerInfo) {
		if (!ObjectUtils.isEmpty(manufacturerInfo.getCountryId())) {
			SystemDic byId = iSystemDicService.getByIdforAll(manufacturerInfo.getCountryId());
			manufacturerInfo.setCountry(byId.getName());
		}
		if (!ObjectUtils.isEmpty(manufacturerInfo.getNatureId())) {
			SystemDic byId = iSystemDicService.getByIdforAll((manufacturerInfo.getNatureId()));
			manufacturerInfo.setNature(byId.getName());
		}
		if (!ObjectUtils.isEmpty(manufacturerInfo.getProvinceId())) {
			SystemDic byId = iSystemDicService.getByIdforAll(manufacturerInfo.getProvinceId());
			manufacturerInfo.setProvince(byId.getName());
		}
		if (!ObjectUtils.isEmpty(manufacturerInfo.getTypeId())) {
			SystemDic byId = iSystemDicService.getByIdforAll(manufacturerInfo.getTypeId());
			manufacturerInfo.setType(byId.getName());
		}
		iManufacturerInfoService.save(manufacturerInfo);
		return manufacturerInfo;
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {

		return iManufacturerInfoService.removeById(id);
	}

	/**
	 * 修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
	public boolean updateByIdManufacturerInfo(HttpServletRequest request,
			@RequestBody ManufacturerInfo manufacturerInfo) {
		if (!ObjectUtils.isEmpty(manufacturerInfo.getCountryId())) {
			SystemDic byId = iSystemDicService.getByIdforAll(manufacturerInfo.getCountryId());
			manufacturerInfo.setCountryId(manufacturerInfo.getCountryId());
			manufacturerInfo.setCountry(byId.getName());
		}
		if (!ObjectUtils.isEmpty(manufacturerInfo.getNatureId())) {
			SystemDic byId = iSystemDicService.getByIdforAll(manufacturerInfo.getNatureId());
			manufacturerInfo.setNatureId(manufacturerInfo.getNatureId());
			manufacturerInfo.setNature(byId.getName());
		}
		if (!ObjectUtils.isEmpty(manufacturerInfo.getProvinceId())) {
			SystemDic byId = iSystemDicService.getByIdforAll(manufacturerInfo.getProvinceId());
			manufacturerInfo.setProvinceId(manufacturerInfo.getProvinceId());
			manufacturerInfo.setProvince(byId.getName());
		}
		if (!ObjectUtils.isEmpty(manufacturerInfo.getTypeId())) {
			SystemDic byId = iSystemDicService.getByIdforAll(manufacturerInfo.getTypeId());
			manufacturerInfo.setTypeId(manufacturerInfo.getTypeId());
			manufacturerInfo.setType(byId.getName());
		}
		return iManufacturerInfoService.updateById(manufacturerInfo);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public ManufacturerInfo selectById(HttpServletRequest request, @PathVariable Long id) {
		ManufacturerInfo manufacturerInfo = iManufacturerInfoService.getById(id);
		return manufacturerInfo;
	}

	/**
	 * 获取企业基础信息
	 * 
	 * @return
	 */
	@RequestMapping(value = "/basic-data", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "获取企业基础信息", notes = "获取企业基础信息")
	public ResponseModel getInitData() {
		ManufactBasicDataResponse basicData = new ManufactBasicDataResponse();
		basicData.setManufacturerNature(iSystemDicService.findAllByType(SystemDicTypeEum.manufacturerNature.getType()));
		basicData.setManufacturerType(iSystemDicService.findAllByType(SystemDicTypeEum.manufacturerType.getType()));
		basicData.setCountry(iSystemDicService.findAllByType(SystemDicTypeEum.country.getType()));
		basicData.setProvince(iSystemDicService.findAllByType(SystemDicTypeEum.region.getType()));
		return CommonResponseUtil.success(basicData);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<ManufacturerInfo> listPage(String pageNum, String pageSize, ManufacturerInfo manufacturerInfo) {

		Page<ManufacturerInfo> pageBean;
		QueryWrapper<ManufacturerInfo> manufacturerInfoQueryWrapper = new QueryWrapper<>();
		Class<? extends ManufacturerInfo> aClass = manufacturerInfo.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(manufacturerInfo);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(manufacturerInfo);
						manufacturerInfoQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(manufacturerInfo);
						manufacturerInfoQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(manufacturerInfo);
						manufacturerInfoQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(manufacturerInfo);
						manufacturerInfoQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<ManufacturerInfo> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iManufacturerInfoService.page(pageBean, manufacturerInfoQueryWrapper);
		return page;
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/page", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<ManufacturerInfo> page(String pageNum, String pageSize, ManufacturerInfo manufacturerInfo) {

		Page<ManufacturerInfo> pageBean;
		QueryWrapper<ManufacturerInfo> manufacturerInfoQueryWrapper = new QueryWrapper<>();
		manufacturerInfoQueryWrapper.like("name", manufacturerInfo.getName());
		manufacturerInfoQueryWrapper.orderByDesc("id");
		IPage<ManufacturerInfo> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iManufacturerInfoService.page(pageBean, manufacturerInfoQueryWrapper);
		System.err.println(page);
		return page;
	}

	/**
	 * 批量删除
	 * 
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public int deleteById(HttpServletRequest request, @RequestBody List<Long> idList) {
		Map<String, Object> map = new HashMap<>();
		int i = 0;
		for (Long a : idList) {
			i += iManufacturerInfoService.finduseManufacturer(a);
		}
		if (i == 0) {
			iManufacturerInfoService.removeByIds(idList);
		}
		return i;
	}

	@RequestMapping(value = "/checkName", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "效验企业名重复", notes = "效验企业名重复")
	public String checkName(String name, Long id) {
		return iManufacturerInfoService.checkName(name, id);
	}
}
