package com.yeejoin.amos.fas.business.controller;

import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentService;
import com.yeejoin.amos.fas.business.service.intfc.IFireCarService;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipService;
//import com.yeejoin.amos.fas.business.service.intfc.IWaterResourceService;
import com.yeejoin.amos.fas.business.util.CommonPageParamUtil;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/fireSource")
@Api(tags = "消防资源api")
public class FireSourceController extends AbstractBaseController {
    @Autowired
    private IFireCarService fireCarService;
    @Autowired
    private IFireEquipService iFireEquipService;
    @Autowired
    private IEquipmentService iEquipService;
    private final Logger log = LoggerFactory.getLogger(FireSourceController.class);


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "删除消防装备", notes = "查询单个消防装备")
    @RequestMapping(value = "/{ids}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
    public CommonResponse delete(@PathVariable String ids) throws Exception {
        String[] idArray = ids.split(",");
        if (iEquipService.countImpEquipByIds(idArray) > 0) {
            return CommonResponseUtil.failure("该设备已被重点设备绑定，请先删除绑定关系");
        }
        return CommonResponseUtil.success(iFireEquipService.delete(idArray));
    }

    /**
     * 消防车查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "查询消防车", notes = "查询消防车")
    @RequestMapping(value = "/fire-car/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryFireCar(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> carList = fireCarService.queryFireCar(getToken(), getProduct(), getAppKey(), param);
        return CommonResponseUtil.success(carList);
    }

    /**
     * 消防车详情查询
     *
     * @param id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询消防车", notes = "查询消防车")
    @RequestMapping(value = "/fire-car/det/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryFireCar(@ApiParam(value = "查询条件", required = true) @PathVariable Long id) {
//        FireCarDetailVo car = fireCarService.findFireCarById(getToken(), getProduct(), getAppKey(), id);
        return CommonResponseUtil.success();
    }

    /**
     * 消防装备查询-查询消防装备及视频监控
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "消防装备查询", notes = "消防装备查询")
    @RequestMapping(value = "/fire-equip/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryFireEquipment(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> carList = iFireEquipService.queryFireEquip(param);
        return CommonResponseUtil.success(carList);
    }

    /**
     * 配套设备查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "配套设备查询", notes = "配套设备查询")
    @RequestMapping(value = "/matching-equip/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryFireEquipmentByProId(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = true) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> carList = iFireEquipService.queryFireEquipByProId(param);
        return CommonResponseUtil.success(carList);
    }

    /**
     * 生产区域查询查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "生产区域查询", notes = "生产区域查询")
    @RequestMapping(value = "/fire-equip/area", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryProArea() {
        List<String> car = iFireEquipService.findFireEquipArea();
        return CommonResponseUtil.success(car);
    }

    //	@Authorization(ingore = true)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询消防设备历史数据", notes = "查询消防设备历史数据")
    @RequestMapping(value = "/data/history", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryForFireEquipmentHistory(
            @ApiParam(value = "设备名称", required = false) @RequestParam(required = false) String fireEquipmentName,
            @ApiParam(value = "按保护对象名称", required = false) @RequestParam(required = false) String equipmentName,
            @ApiParam(value = "开始日期", required = false) @RequestParam(required = false) String startTime,
            @ApiParam(value = "结束日期", required = false) @RequestParam(required = false) String endTime, int pageNumber,
            int pageSize) {

        CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
        return CommonResponseUtil.success(iFireEquipService.queryForFireEquipmentHistory(
                StringUtils.trimToNull(fireEquipmentName), StringUtils.trimToNull(equipmentName),
                StringUtils.trimToNull(startTime), StringUtils.trimToNull(endTime), commonPageable));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询消防设备列表", notes = "查询消防设备列表")
    @RequestMapping(value = "/info/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryForEquipmentList(
            @ApiParam(value = "设备名称", required = false) @RequestParam(required = false) String name,
            @ApiParam(value = "设备编号", required = false) @RequestParam(required = false) String code,
            @ApiParam(value = "设备类型", required = false) @RequestParam(required = false) String equipClassify,
            @ApiParam(value = "是否绑定配套设备", required = false) @RequestParam(required = false) String bindStation,
            int pageNumber, int pageSize) {

        CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
        return CommonResponseUtil.success(iFireEquipService.queryForEquipmentList(StringUtils.trimToNull(name),
                StringUtils.trimToNull(code), StringUtils.trimToNull(equipClassify), commonPageable,StringUtils.trimToNull(bindStation)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防状态明细信息", notes = "消防状态明细信息")
    @RequestMapping(value = "/info/detail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryForEquipmentList(@ApiParam(value = "设备名称", required = true) @RequestParam String id,
                                                @ApiParam(value = "设备编号", required = true) @RequestParam String type) throws Exception {

    	try{
    		 return CommonResponseUtil.success(iFireEquipService.queryForDetail(type, Long.valueOf(id)));
    	}catch (Exception e) {
			log.error(e.getMessage(),e);
			return CommonResponseUtil.failure("消防装备明细查询失败" + e.getMessage());
		}
       
    }
}
