package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.feign.AmosFeignService;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorBaseInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorListDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorMaintenanceInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorNewDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorTestInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorWlInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.EsElevatorDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.EsSpecialEquipmentDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.EsSpecialEquipmentListDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.SpecialEquipmentDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.Elevator;
import com.yeejoin.amos.boot.module.tzs.api.entity.MaintainInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TestInfo;
import com.yeejoin.amos.boot.module.tzs.api.service.IElevatorRelationService;
import com.yeejoin.amos.boot.module.tzs.api.service.IElevatorService;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.ESElevatorServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.ElevatorServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.MaintainInfoServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.TestInfoServiceImpl;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 特种设备API
 */
@RestController
@Api(tags = "特种设备API")
@RequestMapping(value = "/special-equipment")
public class SpecialEquipmentController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(SpecialEquipmentController.class);

    @Autowired
    IElevatorService iElevatorService;

    @Autowired
    ElevatorServiceImpl elevatorService;

    @Autowired
    private AmosFeignService amosFeignService;
    @Autowired
    private MaintainInfoServiceImpl maintainInfoService;
	 @Autowired
	private EquipFeignClient equipFeignClient;
    @Autowired
    private TestInfoServiceImpl testInfoService;

    @Autowired
    ESElevatorServiceImpl esElevatorService;

    @Autowired
    private EmqKeeper emqKeeper;

    @Value("${mqtt.topic.elevator.push}")
    private String elevatorpushTopic;

    @Autowired
    private IElevatorRelationService elevatorRelationService;



    /**
     * ES查询电梯信息
     *
     * @return 查询结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/querySpecialEquipment", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "ES查询八大类信息", notes = "ES查询八大类信息")
    public ResponseModel<Map<String, List<SpecialEquipmentDto>>> querySpecialEquipment(@RequestBody EsSpecialEquipmentDto esSpecialEquipmentDto){
        Map<String, List<SpecialEquipmentDto>> result = new HashMap<>();

        if(StringUtils.isNotBlank(esSpecialEquipmentDto.getCategoryCode())) { // 查找特定设备
            if("3000".equals(esSpecialEquipmentDto.getCategoryCode())) {
                List<SpecialEquipmentDto>  elevatorList = esElevatorService.queryByDto(esSpecialEquipmentDto, true);
                result.put("3000",elevatorList);
            }
        } else { // 查找所有设备
            // 查找电梯数据
            List<SpecialEquipmentDto>  elevatorList = esElevatorService.queryByDto(esSpecialEquipmentDto, false);
            result.put("3000",elevatorList);
        }
        return ResponseHelper.buildResponse(result);
    }



    /**
     * ES查询电梯信息
     *
     * @return 查询结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/querySpecialEquipmentList", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "ES查询八大类列表信息", notes = "ES查询八大类列表信息")
    public ResponseModel<List<SpecialEquipmentDto>> querySpecialEquipmentList(@RequestBody EsSpecialEquipmentListDto eSpecialEquipmentListDto){
        List<SpecialEquipmentDto> result = new ArrayList<>();

        if (ValidationUtil.isEmpty(eSpecialEquipmentListDto.getCategoryCode())) {
            throw new BadRequest("参数校验失败.");
        }
        if("3000".equals(eSpecialEquipmentListDto.getCategoryCode())) {
            result = esElevatorService.queryListByDto(eSpecialEquipmentListDto);
        }
        return ResponseHelper.buildResponse(result);
    }

    /**
     * ES查询电梯信息
     *
     * @return 查询结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/queryTogetherByDto", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "ES查询聚合信息", notes = "ES查询聚合信息")
    public ResponseModel<List<Map<String, String>>> queryTogetherByDto(@RequestBody EsSpecialEquipmentDto esSpecialEquipmentDto){
        List<Map<String, String>> result = new ArrayList<>();
        if (ValidationUtil.isEmpty(esSpecialEquipmentDto.getCategoryCode()) ||
                ValidationUtil.isEmpty(esSpecialEquipmentDto.getPrecision())  ||
                ValidationUtil.isEmpty(esSpecialEquipmentDto.getStartLatitude()) ||
                ValidationUtil.isEmpty(esSpecialEquipmentDto.getStartLongitude()) ||
                ValidationUtil.isEmpty(esSpecialEquipmentDto.getEndLatitude()) ||
                ValidationUtil.isEmpty(esSpecialEquipmentDto.getEndLongitude())) {
            throw new BadRequest("参数校验失败.");
        }
        if(StringUtils.isNotBlank(esSpecialEquipmentDto.getCategoryCode())) { // 查找特定设备
            if("3000".equals(esSpecialEquipmentDto.getCategoryCode())) {
                result = esElevatorService.queryTogetherByDto(esSpecialEquipmentDto);
            }
        }


        return ResponseHelper.buildResponse(result);
    }

}

