package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tzs.api.service.TzsAuthService;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 特种设备权限controller
 */
@RestController
@Api(tags = "特种设备权限Api")
@RequestMapping(value = "/tzs-auth-api")
public class TzsAuthController extends BaseController {



	@Autowired
	TzsAuthService tzsAuthService;

	/**
	 * 判断用户是否是管理员
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/isUserAdmin")
	@ApiOperation(httpMethod = "GET", value = "判断用户是否是管理员", notes = "判断用户是否是管理员")
	public ResponseModel<Boolean> isUserAdmin() {
		Boolean flag = false;
		AgencyUserModel me = Privilege.agencyUserClient.getme().getResult();
		if(me.getUserName().equals("tzs_wjl")) {
			flag = true;
		}
		return ResponseHelper.buildResponse(flag);
	}

	/**
	 *  获取用户regionCode
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUserRegincode")
	@ApiOperation(httpMethod = "GET", value = "获取用户regionCode", notes = "获取用户regionCode")
	public ResponseModel<List<String>> getUserRegincode() {
		List<String> regionList = tzsAuthService.getUserRegionCode();
		AgencyUserModel me = Privilege.agencyUserClient.getme().getResult();
		return ResponseHelper.buildResponse(regionList);
	}

	/**
	 *  获取用户组织机构树
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUserReginTree")
	@ApiOperation(httpMethod = "GET", value = "获取用户组织机构树", notes = "获取用户组织机构树")
	public ResponseModel<Collection<RegionModel>> getUserReginTree() {
        List<String> regionList = tzsAuthService.getUserRegionCode();
		AgencyUserModel me = Privilege.agencyUserClient.getme().getResult();
		List<RegionModel> tree = (List<RegionModel>) Systemctl.regionClient.queryForTree(null).getResult();
		// 循环list 将List 封装为 省市区 SET
		Set<String> city = new HashSet<>();
		Set<String> district = new HashSet<>();
		for(String regionCode : regionList) {
			// 判断是否是某个县
			String districtCode = regionCode.substring(4,6);
			if("00".equals(districtCode)) { // 为市
				city.add(regionCode);
			} else { // 为区
				district.add(regionCode);
			}
		}
		// 判断市区是否存在区域码的市，如果存在则移除区
		Iterator<String> disIt = district.iterator();
		while(disIt.hasNext()) {
			String regionCode = disIt.next();
			String tempCity = regionCode.substring(0,4) + "00";
			if(city.contains(tempCity)) {
				disIt.remove();
			}
		}
		// 将tree 转换为K-V形式便于处理
		Map<Integer, RegionModel> tempMap = new HashMap<Integer, RegionModel>();
		RegionModel start = tree.get(0); // 省
		setMap(tempMap,start);
		List<RegionModel> newTree = new ArrayList<RegionModel>();
		List<RegionModel> newCity = new ArrayList<RegionModel>();
		// 如果管理市 取得整个市的数据 如果管理某个县 取得某市某县数据
		Map<String, RegionModel> tempCityMap = new HashMap<String, RegionModel>();
		for(String regionCode : district) {
			// 先拿市 再封装新的城市
			String cityCode = regionCode.substring(0,4) + "00";
			RegionModel tempCity = tempCityMap.get(cityCode);
			if(tempCity == null) {
				List<RegionModel> tempDisList = new ArrayList<RegionModel>();
				tempDisList.add(tempMap.get(Integer.parseInt(regionCode)));
				tempCity = tempMap.get(Integer.parseInt(cityCode));
				tempCity.setChildren(tempDisList);
				tempCityMap.put(cityCode,tempCity);
			} else {
				List<RegionModel> tempDisList = (List<RegionModel>) tempCity.getChildren();
				tempDisList.add(tempMap.get(Integer.parseInt(regionCode)));
			}
		}
		for(String regionCode : city) {// 获取城市
			newCity.add(tempMap.get(Integer.parseInt(regionCode)));
		}
		// 拼接城市
		for(Map.Entry<String, RegionModel> entries : tempCityMap.entrySet()) {
			newCity.add(entries.getValue());
		}
		start.setChildren(newCity);
		newTree.add(start);
		return ResponseHelper.buildResponse(newTree);
	}

	private void setMap(Map<Integer, RegionModel> tempMap, RegionModel start) {
		tempMap.put(start.getRegionCode(),start);
		if(start.getChildren() != null) {
			List<RegionModel> children = (List<RegionModel>) start.getChildren();
			for (RegionModel temp : children) {
				setMap(tempMap,temp);
			}
		}

	}


}
