package com.yeejoin.amos.boot.module.common.api.entity;

import cn.hutool.core.util.StrUtil;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.*;

import java.time.LocalDate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 使用登记单据搜索实体
 */
@Data
@Document(indexName = "tzs_jg_use_registration_info", shards = 3, replicas = 2, createIndex = false)
public class EsUseRegistrationInfo {
    @Id
    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "sequence_nbr"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String sequenceNbr;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "apply_no"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String applyNo;

    @Field(type = FieldType.Date, name = "audit_pass_date", format = DateFormat.date_hour_minute_second)
    private LocalDate auditPassDate;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "audit_status"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String auditStatus;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "cancel_reason"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String cancelReason;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "code96333"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String code96333;

    @Field(type = FieldType.Date, name = "create_date", format = DateFormat.date_hour_minute_second)
    private LocalDate createDate;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "create_user_id"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String createUserId;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equ_category"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equCategory;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equ_category_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equCategoryCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equ_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equ_define"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equDefine;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equ_define_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equDefineCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equ_list_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equListCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equ_list_name"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equListName;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "equip_ids"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String equipIds;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "instance_id"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String instanceId;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "is_delete"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String isDelete;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "manage_type"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String manageType;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "next_execute_ids"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String nextExecuteIds;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "next_execute_user_ids"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String nextExecuteUserIds;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "next_task_id"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String nextTaskId;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "org_branch_name"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String orgBranchName;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "project_contraption_id"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String projectContraptionId;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "promoter"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String promoter;

    @Field(type = FieldType.Date, name = "rec_date", format = DateFormat.date_hour_minute_second)
    private LocalDate recDate;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "receive_company_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String receiveCompanyCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "receive_org_name"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String receiveOrgName;

    @Field(type = FieldType.Date, name = "reg_date", format = DateFormat.date)
    private LocalDate regDate;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "reg_type"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String regType;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "status"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String status;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "supervision_org_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String supervisionOrgCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "supervisory_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String supervisoryCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "transfer_to_user_ids"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String transferToUserIds;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "use_address"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String useAddress;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "use_registration_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String useRegistrationCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "use_unit_credit_code"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String useUnitCreditCode;

    @MultiField(
            mainField = @Field(type = FieldType.Text, name = "use_unit_name"),
            otherFields = {
                    @InnerField(suffix = "keyword", type = FieldType.Keyword)
            }
    )
    private String useUnitName;

    // 预处理：建立下划线字段名到驼峰字段名的映射缓存
    public static final Map<String, String> UNDERSCORE_TO_CAMEL = new ConcurrentHashMap<>();

    // 实体类字段映射
    static {
        initFieldMapping();
    }

    public static void initFieldMapping() {
        java.lang.reflect.Field[] fields = EsUseRegistrationInfo.class.getDeclaredFields();
        for (java.lang.reflect.Field field : fields) {
            String underscoreName = StrUtil.toUnderlineCase(field.getName());
            UNDERSCORE_TO_CAMEL.put(underscoreName, field.getName());
        }
    }

}