package com.yeejoin.amos.boot.module.jczs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 企业信息表
 *
 * @author system_generator
 * @date 2021-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_flc_unit_info")
public class UnitInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单位名称
     */
	@TableField("org_name")
    private String orgName;

    /**
     * 证照类型
     */
	@TableField("licence_type")
    private String licenceType;

    /**
     * 证照类型code
     */
	@TableField("licence_type_code")
    private String licenceTypeCode;

    /**
     * 组织机构编码
     */
    @TableField("organization_code")
    private String organizationCode;

    /**
     * 单位类型
     */
	@TableField("unit_type")
    private String unitType;

    /**
     * 单位类型code
     */
	@TableField("unit_type_code")
    private String unitTypeCode;

    /**
     * 主管部门
     */
	@TableField("comptent_dept")
    private String comptentDept;

    /**
     * 主管部门编号
     */
	@TableField("comptent_dept_code")
    private String comptentDeptCode;

    /**
     * 批准成立机关
     */
	@TableField("approve_org")
    private String approveOrg;

    /**
     * 登记机构
     */
	@TableField("registration_authority")
    private String registrationAuthority;

    /**
     * 区域编码
     */
	@TableField("region_code")
    private String regionCode;

    /**
     * 国家
     */
	@TableField("country")
    private String country;

    /**
     * 省
     */
	@TableField("province")
    private String province;

    /**
     * 市
     */
	@TableField("city")
    private String city;

    /**
     * 县区
     */
	@TableField("district")
    private String district;

    /**
     * 街道
     */
	@TableField("stree")
    private String stree;

    /**
     * 小区
     */
	@TableField("community")
    private String community;

    /**
     * 详细地址
     */
	@TableField("address")
    private String address;

    /**
     * 经度
     */
	@TableField("longitude")
    private String longitude;

    /**
     * 纬度
     */
	@TableField("latitude")
    private String latitude;

    /**
     * 管辖单位
     */
	@TableField("management_unit")
    private String managementUnit;

    /**
     * 管辖单位id
     */
	@TableField("management_unit_id")
    private Long managementUnitId;

    /**
     * 资质等级
     */
	@TableField("qualification_level")
    private String qualificationLevel;

    /**
     * 资质等级编号
     */
	@TableField("qualification_level_code")
    private String qualificationLevelCode;

    /**
     * 成立日期
     */
	@TableField("create_time")
    private Date createTime;

    /**
     * 单位法人
     */
	@TableField("legal_person")
    private String legalPerson;

    /**
     * 法人电话
     */
	@TableField("legal_person_tel")
    private String legalPersonTel;

    /**
     * 单位联系人
     */
	@TableField("contact_person")
    private String contactPerson;

    /**
     * 联系人电话
     */
	@TableField("contact_person_tel")
    private String contactPersonTel;

    /**
     * 单位电话
     */
	@TableField("unit_tel")
    private String unitTel;

    /**
     * 管理员姓名
     */
	@TableField("admin_name")
    private String adminName;

    /**
     * 管理员用户名
     */
	@TableField("admin_login_name")
    private String adminLoginName;

    /**
     * 管理员密码
     */
	@TableField("admin_login_pwd")
    private String adminLoginPwd;

    /**
     * 管理员手机号
     */
	@TableField("admin_tel")
    private String adminTel;

    /**
     * org_user_id
     */
	@TableField("org_user_id")
    private Long orgUserId;

    /**
     * 审批状态 0 审批中 1 审批结束 2 驳回
     */
	@TableField("unit_status")
    private Integer unitStatus;

    /**
     * 是否变更 0 未变更 1 变更中
     */
    @TableField(value = "is_change")
    private Boolean isChange;


    /**
     * 企业入驻时间
     */
    @TableField("approved_time")
    private Date approvedTime;
    /**
     * 提交时间
     */
    @TableField("submit_time")
    private Date submitTime;

    /**
     * 驳回id
     */
    @TableField("callback_id")
    private String callbackId;

}
