package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 移装变更登记登记
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_change_registration_transfer")
public class JgChangeRegistrationTransfer extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备监管码
     */
	@TableField("supervisory_code")
    private String supervisoryCode;

    /**
     * 使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 办理状态
     */
	@TableField("audit_status")
    private String auditStatus;

    /**
     * 登记机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 检验单位
     */
	@TableField("inspect_unit_name")
    private String inspectUnitName;

    /**
     * 检验结果照片
     */
	@TableField("inspect_result_photo")
    private String inspectResultPhoto;

    /**
     * 检验结果
     */
	@TableField("inspect_result")
    private String inspectResult;

    /**
     * 终审通过时间
     */
	@TableField("audit_pass_date")
    private Date auditPassDate;

    /**
     * 登记类别
     */
	@TableField("reg_type")
    private String regType;

    /**
     * 注册登记日期
     */
	@TableField("reg_date")
    private Date regDate;

    /**
     * 注册登记人员ID
     */
	@TableField("reg_person_id")
    private String regPersonId;

    /**
     * 注册登记人员
     */
	@TableField("reg_person_name")
    private String regPersonName;

    /**
     * 安装单位名称
     */
	@TableField("install_unit_name")
    private String installUnitName;

    /**
     * 状态
     */
	@TableField("status")
    private String status;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
    @TableField(value = "create_user_id")
    private String createUserId;

    /**
     * 创建人名称
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 创建时间
     */
	@TableField(value = "create_date")
    private Date createDate;

    /**
     * 录入单位统一信用代码
     */
	@TableField("input_unit_no")
    private String inputUnitNo;

    /**
     * 使用登记编号
     */
	@TableField("use_registration_code")
    private String useRegistrationCode;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 检验机构统一信用代码
     */
	@TableField("inspect_unit_credit_code")
    private String inspectUnitCreditCode;

    /**
     * 流程执行顺序标识
     */
	@TableField("execute_sequence")
    private String executeSequence;

    /**
     * 登记机构代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 登记机构公司代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 下一执行节点ids
     */
	@TableField("next_executor_ids")
    private String nextExecutorIds;

    /**
     * 移装告知申请id
     */
	@TableField("reform_notice_id")
    private String reformNoticeId;

    /**
     * 任务发起人id
     */
	@TableField("promoter")
    private String promoter;

    /**
     * 使用登记证书附件
     */
    @TableField("use_registration_certificate")
    private String useRegistrationCertificate;

    /**
     * 流程状态
     */
    @TableField("instance_status")
    private String instanceStatus;

    /**
     *工作流下一节点任务id
     */
    @TableField(value = "next_task_id")
    private String nextTaskId;

    /**
     * 创建单位名称
     */
    @TableField(value = "create_user_company_name")
    private String createUserCompanyName;

    /**
     * 设备种类名称
     */
    @TableField(value = "equip_list_name")
    private String equipListName;

    /**
     * 下一节点可执行人
     */
    @TableField(value = "next_execute_user_ids")
    private String nextExecuteUserIds;

    /**
     * 设备移装完整详细地址
     */
    @TableField(value = "full_address")
    private String fullAddress;

    /**
     * 转办后执行人的Id逗号分割
     */
    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;

    /**
     * 接收机构公司的org_code
     */
    @TableField("receive_company_org_code")
    private String receiveCompanyOrgCode;

    /**
     * 移装类型（0区内，1区外）
     */
    @TableField("transfer_type")
    private String transferType;

    /**
     * 其他附件
     */
    @TableField(value = "other_accessories")
    private String otherAccessories;
}
