package com.yeejoin.amos.boot.module.tdc;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;

import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;


import java.net.InetAddress;


/**
 * <pre>
 * 三维校验服务启动类
 * </pre>
 *
 * @author DELL
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@EnableScheduling
@MapperScan({ "org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
		"org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
		"com.yeejoin.amos.boot.module.**.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper" })
@ComponentScan(basePackages = { "org.typroject", "com.yeejoin.amos.boot.module.tdc.api.service" })
public class AmosTdcApplication {

	private static final Logger logger = LoggerFactory.getLogger(AmosTdcApplication.class);

	public static void main(String[] args) throws Exception {
		ConfigurableApplicationContext context = SpringApplication.run(AmosTdcApplication.class, args);
		Environment env = context.getEnvironment();
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));

		logger.info("\n----------------------------------------------------------\n\t"
				+ "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
				+ path + "/doc.html\n" + "----------------------------------------------------------");
	}

//	/**
//	 * 初始化MQTT
//	 *
//	 * @throws MqttException
//	 */
//	@Bean
//	public void initMqtt() throws MqttException {
//		emqKeeper.getMqttClient().subscribe("/idx/idx_biz_carcyl_unit_inspect", 1, carcylUnitInspectMqTtlListener);
//		emqKeeper.getMqttClient().subscribe("/tm/tz_base_enterprise_info", 1, baseEnterpriseMqTtlListener);
//		emqKeeper.getMqttClient().subscribe("/tz/privilege_company_add_update",1, privilegeCompanyUpdateAddListener);
//		emqKeeper.getMqttClient().subscribe("/tz/privilege_company_delete",1, privilegeCompanyDeleteListener);
////		emqKeeper.getMqttClient().subscribe("topic_mqtt_exam", 1, examMqTtlListener);
////		emqKeeper.getMqttClient().subscribe("topic_mqtt_exam_record", 1, examMqTtRecordListener);
//	}

//	@Bean
//	public void initToken() {
//		startPlatformTokenService.getToken();
//	}
}
