package com.yeejoin.amos.boot.module.tdc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tdc.api.dto.SwjySylbDto;
import com.yeejoin.amos.boot.module.tdc.api.entity.SwjySylb;
import com.yeejoin.amos.boot.module.tdc.service.impl.SwjySylbServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@Api(tags="api")
@RequestMapping(value = "/swjy-sylb", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class SwjySylbController {

    @Autowired
    SwjySylbServiceImpl swjySylbService;
    /**
     * 根据amosOrgName查询
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/{amosOrgName}")
    @ApiOperation(httpMethod = "GET",value = "根据amosOrgName查询单个",  notes = "根据amosOrgName查询单个")
    public ResponseModel<List<SwjySylbDto>> selectName(@PathVariable SwjySylbDto swjySylbDto)
    {


        return ResponseHelper.buildResponse(swjySylbService.selectName(swjySylbDto));
    }

//    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping
    @ApiOperation(httpMethod = "GET",value = "根据amosOrgName查询单个",  notes = "根据amosOrgName查询单个")
    public ResponseModel<List<SwjySylb>> selectName1()
    {


        return ResponseHelper.buildResponse(swjySylbService.list());
    }
}
