package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 人员数据信息-基本信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_staff_base_info")
@ApiModel(value="TmJgStaffBaseInfo对象", description="人员数据信息-基本信息")
public class StaffBaseInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "作业人员身份号码")

    private String operatorId;

    @ApiModelProperty(value = "作业人员姓名")
    private String operator;

    @ApiModelProperty(value = "作业人员证件类型")
    private String operatorIdType;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "工作单位代码")
    private String unitCode;

    @ApiModelProperty(value = "工作单位名称")
    private String unit;

    @ApiModelProperty(value = "聘用时间")
    private Date employmentDate;

}
