package com.yeejoin.equipmanage.fegin;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.feign.systemctl.model.MessageModel;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.fegin
 * @ClassName: JcsFeign
 * @Author: Jianqiang Gao
 * @Description: JcsFeign
 * @Date: 2021/7/20 10:39
 * @Version: 1.0
 */
@FeignClient(name = "${security.systemctl.name}", configuration = {MultipartSupportConfig.class})
public interface SystemctlFeign {

    @RequestMapping(value = "/systemctl/v1/message", method = RequestMethod.POST, consumes = "application/json")
    ResponseModel<MessageModel> create(
    		@RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestBody MessageModel model);

    @RequestMapping(value = "/systemctl/v1/message/{sequenceNbr}", method = RequestMethod.PUT, consumes = "application/json")
    ResponseModel<MessageModel> updateIsRead(@PathVariable(value = "sequenceNbr") Long sequenceNbr
          );

}
